#include "string_util.h"
#include <string.h>
#include <stdlib.h>

void strip_newline( char *buf ) {
  if( buf[strlen(buf) - 1] == '\n' ) {
    buf[strlen(buf) - 1] = 0;
  }
}

char *next_token( const char *str, int *s, int *e, const char *delim ) {
	int len;
	char *tok;
  *s = *e;

  if( *s == 0 ) *s = -1;

  do {
    (*s)++;
  } while( str[*s] != 0 && strchr( delim, str[*s] ) );

  if( str[*s] == 0 ) return NULL;

  *e = *s;

  while( ! (str[*e] == 0 || str[(*e)+1] == 0 || strchr( delim, str[*e+1] ) ) ) {
    (*e)++;
  }

  len = *e-*s + 1;

  if( len == 0 ) return NULL;

  tok = (char *)malloc( len + 1 );
  memcpy( tok, str + *s, len );
  tok[len] = 0;

  return tok;
}
