#include "search_dirs.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
//#include "../config.h"
#include <assert.h>

#include <sys/types.h>
#include <sys/stat.h>
//#include <unistd.h>

static int n_paths=0;
static char **paths;

char *search_file( const char *filename ) {
  int idx;
  char *buf = malloc( 512 );
  struct stat stat_buf;
  for( idx = 0; idx < num_search_dirs(); idx++ ) {
    char *dir = get_search_dir( idx );
    
    sprintf( buf, "%s%s", dir ,filename );
    free( dir );

    if( 0 == stat( buf, &stat_buf ) ) {
      return buf;
    }
  }
  free( buf );
  return NULL;
}   

void load_search_dirs() {
  load_search_dirs_fn( "./config_file/search_dirs.cf" );
}

void load_search_dirs_fn( const char *filename ) {
  ConfigurationData *search_dirs = NULL;
  int idx = n_paths, i=0;

  search_dirs = load_conf_data( filename );
  assert( search_dirs );
  
  n_paths+=search_dirs->rows;
  paths = (char **)malloc( paths, n_paths*sizeof(char *) );
  for( ; idx < n_paths; idx++,i++ ) { 
    paths[idx] = NULL;
    strdup(search_dirs->names[i] );    

    paths[idx] =    strdup(search_dirs->names[i] );    

  }

  free_conf_data( search_dirs );
}

int num_search_dirs() {
  return n_paths+3;
}

char *get_search_dir( int i ) {
  //int n = num_search_dirs();

  //if( i < 0 || i > num_search_dirs()-1 ) {
  //  return NULL;
  //}

  //if( i == num_search_dirs()-1 ) {
  //  return strdup( "./" );
  //}
  //if( i == num_search_dirs()-2 ) {
  //  char *env_dir = "../..user/config/";
  //  /*if( !env_dir ) {
  //    printf( "CONFIG_DIR is not in the environment, this will probably cause problems...\n" );
  //  }*/
  //  return env_dir?strdup(env_dir):strdup( "/" );
  //}
  //if( i == num_search_dirs()-3 ) {
  //  return strdup( "/" );
  //}
	return strdup( "./" );

  //return strdup(paths[i]);
}
