#ifndef __DORO_CONF
#define __DORO_CONF

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  int elements; //max elements per row
  int *row_els; //elements on each row
  int rows, num_strings;
  char **names;
  char **string_names;
  float **data;
  char **strings;
  char *filename;
} ConfigurationData;

  ConfigurationData *load_conf_data( const char *filename );
  ConfigurationData *new_conf_data( int elements, int rows );
  float *get_conf_row( ConfigurationData *data, const char *name );

  float get_value_with_default( ConfigurationData *data, const char *name, float default_value );
  void set_value( ConfigurationData *data, const char *name, float value );

  int conf_has_field( ConfigurationData *data, const char *name );
  int conf_has_string( const ConfigurationData *data, const char *name );
  int config_write( ConfigurationData *data );
  void free_conf_data( ConfigurationData *data );
  int get_conf_row_len( const ConfigurationData *data, const char *buf );
  char *get_conf_string( const ConfigurationData *data, const char *string_name );
  char *get_conf_string_with_default( const ConfigurationData *data, const char *string_name, const char *default_string );
  void save_vector( ConfigurationData *conf, char *name, char *filenum ) ;
  void load_vector( ConfigurationData *conf, char *name, float **vec, int *v_len );

  int conf_num_rows( ConfigurationData *cd );
  char *conf_row_name( ConfigurationData *cd, int idx );

#ifdef __cplusplus
}
#endif

#endif
