#include "basic_server.h"
#include <Windows.h>

Basic_Server::Basic_Server(){

	hInputReadyEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	hOutputReadyEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	hWaitingEvent = CreateEvent(NULL, TRUE, TRUE, NULL);

	// start the thread
	hThread = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)Basic_Server_Thread,this,0,&lpThreadID);
	
}

int Basic_Server::Start(void *ptr){
	
	// make sure the thread isn't already busy
	if(WaitForSingleObject(hWaitingEvent,0) != WAIT_OBJECT_0)	return 0;
	
	Send(ptr);

	// signal that an input is ready
	SetEvent(hInputReadyEvent);
	ResetEvent(hWaitingEvent);

	return 1;
}


int Basic_Server::Finish(void *ptr){
	
	// check if an output is waiting
	if(WaitForSingleObject(hOutputReadyEvent,0) != WAIT_OBJECT_0)	return 0;

	// return a pointer to the solver
	Receive(ptr);
	
	// signal that the server is waiting for another input
	SetEvent(hWaitingEvent);
	ResetEvent(hOutputReadyEvent);

	return 1;
}


void Basic_Server::Basic_Server_Thread(void *ptr){
	Basic_Server *s = (Basic_Server*)ptr;

	while(1){
		WaitForSingleObject(s->hInputReadyEvent,INFINITE);		

		s->Evaluate();

		SetEvent(s->hOutputReadyEvent);
	}
}
