
/* this class converts UIEvent and its subclasses MouseEvent and KeyboardEvent into more convenient strings
like "LEFT_MOUSE_DOWN". When created from a string like "CONTROL_K", it will leave x,y as 0,0, but the event version
can specify all the fields.

Fields of a BehaviorEvent will include at least:
    x, y: of the event, in the global (window) coordinate system
    id - what type of event, like mouse button or keyboard key
    modifiers - whether the following are down (true) or not (false): shift, control, alt, windows, function, command
    key - the actual key or button, like f or esc or left_mouse_down
*/

class BehaviorEvent {
    constructor(eventOrString) {
        if (typeof(eventOrString)==='string')
             this.BehaviorEventFromString(eventOrString);
    else if (eventOrString instanceof UIEvent)
             this.BehaviorEventFromUIEvent(eventOrString);
    else console.error("wrong type of parameter to create a BehaviorEvent");
   }
    /* 
     set my fields from a string like "CONTROL_LEFT_MOUSE_DOWN" or "SHIFT_F1" or "ESC".
     Modifiers are required to be listed first.
    */
    BehaviorEventFromString(eventString) {  }

    /* 
     set my fields from a UIEvent object, which will probably either be a MouseEvent and KeyboardEvent"
    */
   BehaviorEventFromUIEvent(uiEvent) {  }
   
   /* 
     checks if the parameter matches this. Ignores fields like x,y and only looks at the modifiers (SHIFT, CONTROL)
     id (like mouse or keyboard) and key (like left_mouse_down or y or esc)
   */
   matches(otherBehaviorEvent) {
       return false;
   }

   /* returns a string describing this event, ignoring the X,Y, etc. The returned string, if passed to matches() should
      return true with this object
   */
   toString() {
       return "";
   }
}
