/* top level behavior class. Create subclasses
  for MoveBehavior, ChoiceBehavior, etc.
  */

 const IDLE = 0;
 const RUNNING_INSIDE = 1;
 const RUNNING_OUTSIDE = 2;

class Behavior {

    constructor(group=UNDEFINED, 
            startEvent = new BehaviorEvent("LEFT_MOUSE_DOWN"), 
            stopEvent = new BehaviorEvent("LEFT_MOUSE_UP"), 
            abortEvent = new BehaviorEvent("ESC")) {
        this.group = group;
        this.startEvent = startEvent;
        this.stopEvent = stopEvent;
        this.abortEvent = abortEvent;
        this.state = IDLE;
        this.affectedObject = null;  // will be an object in the group 
      }
    
    /* Test whether should start based on incoming BehaviorEvent. Check to see if event matches this.startEvent, and if
    a member of this.group contains the event location, as appropriate. Return true if this interactor starts,
    and therefore consumes the event. Also will change this.state appropriately.
    */
    start (event) {
        // do appropriate checks and start behavior if appropriate
        return false;
    }

    /* process this BehaviorEvent for this behavior, which will often be a MOUSE_MOVED event. 
    Be sure to test whether should switch to RUNNING_INSIDE or RUNNING_OUTSIDE.
    Check to see if the event matches this.STOP_EVENT or the ABORT_EVENT, and if so, directly call stop() or abort(). 
    Return true if this behavior consumes the event, and false if not.*/
    running (event) {
        return true;
    }

     /* check to see if the BehaviorEvent matches this.STOP_EVENT and if so, stop and perform the behavior. Returns true if stops, else returns false. */
    stop (event) {
        //do behavior-relevant stopping stuff, like actually changing the affected object
        return false;
    }

     /* check to see if the BehaviorEvent matches this.CANCEL_EVENT and if so, cancel the behavior as if the behavior was never started.
     Returns true if stops, else returns false. */
     cancel (event) {
         return false;
     }
}

// *** NOTE: You should move each behavior into its own .js file for ease of editing

/* move the object in group that startEvent is on. MoveBehavior has no extra parameters.
*/
class MoveBehavior extends Behavior {
}


const SELECT_SINGLE = 0;
const SELECT_MULTIPLE = 1;

/* allows user to select one (if selectType==SELECT_SINGLE) or more if selectType==SELECT_MULTIPLE) of the objects in the group.
  If firstOnly is false, then as move around, interimSelected can move from item to item in group.
  If firstOnly is true, then will only affect the first object that the behavior starts on.
  Sets the selected and interimSelected fields of the object in the group appropriately. 
  There should be constraints from graphical properties that use selected and interimSelected.
*/
class ChoiceBehavior extends Behavior {
    constructor(group=UNDEFINED, 
        startEvent = new BehaviorEvent("LEFT_MOUSE_DOWN"), 
        stopEvent = new BehaviorEvent("LEFT_MOUSE_UP"), 
        abortEvent = new BehaviorEvent("ESC"),
        selectType = SELECT_SINGLE, firstOnly = true) {
        super(group, startEvent, stopEvent, abortEvent);
        this.firstOnly = firstOnly;
     }
     /* getSelection returns the current list of selected objects. Returns an empty list if nothing selected. 
        Even in SELECT_SINGLE mode, always returns a list, which then will have 0 or 1 element in the list.
     */
     getSelection () {
         return [];
     }
}

/* allows user to create a new instance of protoObjToMake, which is added to this.group.
if onePoint is true, then creates the object immediately when this.startevent happens.
if asLine is true, then creates a new line-type object that is defined by x1,y1,x2,y2, otherwise, if false, 
    creates an object that takes x,y,width,height.
If onePoint is false, then uses interimFeedbackObj as the feedback until this.stopEvent or this.cancelEvent,
and then creates the new object on stopEvent.
Creates the object by calling the makeObjFunction, passing in the coordinates from the mouse, 
    either as a line or rectangle.
*/
class NewBehavior extends Behavior {
    constructor(group=UNDEFINED, 
        startEvent = new BehaviorEvent("LEFT_MOUSE_DOWN"), 
        stopEvent = new BehaviorEvent("LEFT_MOUSE_UP"), 
        abortEvent = new BehaviorEvent("ESC"),
        onePoint = false,
        asLine = false,
        makeObjFunction = function(a,b,c,d) {return null},
        interimFeedbackObj = null) {
        super(group, startEvent, stopEvent, abortEvent);
        this.onePoint = onePoint;
        this.protoObjToMake = protoObjToMake;
        this.interimFeedbackObj = interimFeedbackObj;
    }
}