/*
 * To create your own tests, extend the TestHarness class. Do not edit this file.
   See testTestHarness for an example.
 */
class TestHarness {
  constructor(topGraphics) {
    this.testRig = new TestRig(); // initializes the testing output, do not change
    this.topGraphics = topGraphics;
  }

  async runTest() {
    // Test operations go here
  }

  message(str) {
    this.testRig.message(str);
  }
  messageSpan(str) {
    this.testRig.messageSpan(str);
  }

    /* Use this as: 
        await this.waitForUser();
    */
  async waitForUser() {
    return this.testRig.waitForUser();
  }
  // returns a random int between 0..(num-1) inclusive
  RandomInt(num) {
		return Math.floor(Math.random() * num);
	}
  
  /* Use this as: 
    await this.sleep(1000); 
  */
  async sleep(milleseconds) {
    return new Promise(accept => {
      setTimeout(() => accept(), milleseconds);
    });
}


}

/*
 * Do not change the testing rig.
 */
class TestRig {
  constructor() {
    this.testConsole = document.getElementById("testConsole_text");
  }

  async waitForUser() {
    this.waitMessage();
    return new Promise(accept => {
      document.addEventListener("click", () => accept(), { once: true });
    });
  }

  waitMessage() {
    let msg = document.createElement("p");
    msg.classList.add("waitMessage");
    msg.innerHTML = "&nbsp;&nbsp;&nbsp;Please click to continue ...";
    this.testConsole.prepend(msg);
  }

  /* prints the str on the pretend console at the bottom of the test canvas, 
     followed by a newline, using <p> */
  message(str) {
    let msg = document.createElement("p");
    msg.innerHTML = str;
    this.testConsole.prepend(msg);
  }
   /* prints the str on the pretend console at the bottom of the test canvas, 
     on the same line as the previous output, using <span> */
  messageSpan(str) {
    let latestMsg = this.testConsole.firstElementChild;
    // in case there is no existing line
    if (!latestMsg) this.message(str);
    else {
      let msg = document.createElement("span");
      msg.innerHTML = str;
      latestMsg.appendChild(msg);
    }
  }
}
