public class Event {
    private int id;
    private int modifiers;
    private int key;
    private int x;
    private int y;

    public Event (int id, int modifiers, int key, int x, int y) {
        this.id = id;
        this.modifiers = modifiers;
        this.key = key;
        this.x = x;
        this.y = y;
    }

    public int getID () {
        return id;
    }

    public int getModifiers () {
        return modifiers;
    }

    public int getKey () {
        return key;
    }

    public int getX () {
        return x;
    }

    public int getY () {
        return y;
    }

    public boolean matches (Event event) {
        return 
            event.id == id
            && ((modifiers & event.modifiers) == modifiers) //sometimes there are some out of range
            && event.key == key;
    }

    public final static int KEY_DOWN = 0;
    public final static int KEY_UP = 1;
    public final static int MOUSE_DOWN = 2;
    public final static int MOUSE_UP = 3;
    public final static int MOUSE_MOVE = 4;
}
