import java.awt.*;
import java.awt.event.*;
import java.awt.geom.AffineTransform;

import javax.swing.*;
import java.util.*;
import java.util.List;

// *** NOTE: This code has not been tested; sorry ***
// A few bugs fixed and lightly tested by jsstylos, 10/14/04

public class WindowGroup extends JFrame implements Group {

    private Image buffer;
    private JComponent canvas;
    private JTextArea message;

    public WindowGroup (String title, int width, int height) {
        super (title);

        MouseListener ml = new MouseAdapter () {
                public void mousePressed (MouseEvent event) {
                    unpause ();
                }
            };
        addMouseListener (ml);

        addWindowListener (new WindowAdapter () {
                public void windowClosing (WindowEvent event) {
                    System.exit (0);
                }
            });

        Container content = getContentPane ();
        content.setLayout (new BorderLayout ());

        canvas = new JComponent () {
                public void paintComponent (Graphics g) {
                    redraw ();
                    if (buffer != null)
                        g.drawImage (buffer, 0, 0, null);
                }
            };
        canvas.setBackground (Color.white);
        canvas.setPreferredSize (new Dimension (width, height));
        content.add (BorderLayout.CENTER, canvas);

        message = new JTextArea (10, 40);
        message.setEditable (false);
        message.addMouseListener (ml);
        content.add (BorderLayout.SOUTH, new JScrollPane (message));
    
        pack ();
        setVisible(true);
        //show ();  //Deprecated

        makeBuffer (width, height); // must be after show()
    }

    //
    // Drawing GraphicalObjects in the window.
    //
    Rectangle savedClipRect = null;
    LinkedList children = new LinkedList ();
    //
    // Drawing GraphicalObjects in the window.
    //
    
    public synchronized void redraw () {
	if (savedClipRect != null) {
	    Graphics2D g = (Graphics2D) buffer.getGraphics ();
            g.setColor (canvas.getBackground ());
            g.fill (savedClipRect);
	    for (ListIterator iter = children.listIterator (); iter.hasNext (); ) {
		GraphicalObject gobj = (GraphicalObject) iter.next ();
		Rectangle r = gobj.getBoundingBox ();
		if (r.intersects(savedClipRect))//(damagedArea))
		    gobj.draw(g, savedClipRect);
	    }
	    savedClipRect = null;
	}
	else println("no clip rectangle");
    }

    private void makeBuffer (int width, int height) {
        buffer = createImage (width, height);
        Graphics2D g = (Graphics2D) buffer.getGraphics ();
        g.setColor (canvas.getBackground ());
        g.fillRect (0, 0, width, height);
    }

    private void addClipRect(Rectangle r) {
	if (savedClipRect != null) savedClipRect.add(r);
	else savedClipRect = new Rectangle(r);
    }

    //
    // Group interface
    //


    public void addChild (GraphicalObject child) {
        child.setGroup (this);
        children.add (child); 
        damage (child.getBoundingBox ());
    }
    public void removeChild (GraphicalObject child) {
        children.remove (child);
        damage (child.getBoundingBox ());
    }
    public void bringChildToFront (GraphicalObject child) {
        children.remove (child);
        children.add (child);
    }
    public void resizeToChildren () {
    }
    public synchronized void damage (Rectangle rectangle) {
	addClipRect(rectangle);
        canvas.repaint ();
    }
    public void draw (Graphics2D graphics) {
    }
    public Rectangle getBoundingBox () {
        return canvas.getBounds ();
    }
    public void moveTo (int x, int y) {
    }
    public Group getGroup () {
        return null;
    }
    public void setGroup (Group group) {
    }
    public List getChildren () {
        return children;
    }
    public Point parentToChild (Point pt) {
        return pt;
    }
    public Point childToParent (Point pt) {
        return pt;
    }

    // 
    // Message output
    //

    public void print (Object msg) {
        message.append (msg.toString ());
        message.setCaretPosition (message.getDocument ().getLength ());
    }

    public void println (Object msg) {
        print (msg + "\n");
    }

    // 
    // Sleeping
    //

    public void sleep (int msec) {
        try {
            Thread.sleep (msec);
        } catch (InterruptedException e) {
        }
    }

    //
    // Waiting for mouse clicks
    //

    public void pause () {
        println ("click to continue...");
        synchronized (this) {
            try {
                wait ();
            } catch (InterruptedException e) {
            }
        }
    }

    public void unpause () {
        synchronized (this) {
            notify ();
        }
    }


    //
    // Random selections
    //

    private static Random r = new Random ();

    public int random (int n) {
        return r.nextInt (n);
    }

    public Object random (Object[] things) {
        return things[random (things.length)];
    }


    //
    // Loading images from disk
    // Guarantees that the image is loaded, so you don't have to pass
    // an ImageObserver when you call getWidth(), getHeight(), or
    // drawImage().
    // 

    private MediaTracker tracker = new MediaTracker (new Label (""));
    private int nextID = 0;

    public Image loadImageFully (String filename) {
        Image image = getToolkit ().getImage (filename);
        int id = nextID++;
        tracker.addImage (image, id);
        try {
            try {
                tracker.waitForID (id);
            } finally {
                tracker.removeImage (image);
            }
        } catch (InterruptedException e) {
        }
        return image;
    }

    public void resizeChild (GraphicalObject child) {
        // TODO Auto-generated method stub
        
    }

    public void draw (Graphics2D graphics, Shape clipRect) {
        // TODO Auto-generated method stub
        
    }

    public void setAffineTransform (AffineTransform af) {
        // TODO Auto-generated method stub
        
    }

    public AffineTransform getAffineTransform () {
        // TODO Auto-generated method stub
        return null;
    }

}
