import java.awt.*;



public class TestRect extends TestFrame {



    public static void main (String[] args) {

        new TestRect (args);

    }



    public TestRect (String[] args) {

        super ("TestRect", 200, 200);



        int lineThickness = 1;

        try {

            lineThickness = Integer.parseInt (args[0]);

            println ("line thickness = " + lineThickness);

        } catch (Exception e) {

            println ("usage:  TestRect [line thickness]\n"

                                + "using line thickness = "

                                + lineThickness + " by default"); 

        }



        println ("creating Rect");

        Rect r = new Rect (10, 10, 50, 50, Color.red, lineThickness);

        addChild (r);

        pause ();



        println ("moving rectangle with setX(), setY()");

        for (int x = 10; x < 150; x += 30) {

            r.setX (x);

            for (int y = 10; y < 150; y += 30) {

                r.setY (y);

		addClipRect(r.getBoundingBox());

                redraw (r);

                sleep (100);

            }

        }

        println ("final bounding box is " + r.getBoundingBox ());

        println ("final x/y position is " 

                            + r.getX () + "," + r.getY ());

        pause ();



        println ("changing to blue");

        r.setColor (Color.blue);

	addClipRect(r.getBoundingBox());

        redraw (r);

        pause ();



        println ("moving rectangle with moveTo ()");

        for (int x = 10; x < 150; x += 30) {

            for (int y = 10; y < 150; y += 30) {

                r.moveTo (x, y);

	addClipRect(r.getBoundingBox());

                redraw (r);

                sleep (100);

            }

        }

        println ("final bounding box is " + r.getBoundingBox ());

        println ("final x/y position is " 

                            + r.getX () + "," + r.getY ());

        pause ();



        println ("doubling line thickness to " + lineThickness*2);

        r.setLineThickness (lineThickness*2);

	addClipRect(r.getBoundingBox());

        redraw (r);

        pause ();



        println ("moving rectangle with moveTo ()");

        for (int x = 10; x < 150; x += 30) {

            for (int y = 10; y < 150; y += 30) {

                r.moveTo (x, y);

	addClipRect(r.getBoundingBox());

                redraw (r);

                sleep (100);

            }

        }

        println ("final bounding box is " + r.getBoundingBox ());

        println ("final x/y position is " 

                            + r.getX () + "," + r.getY ());



        println ("close the window to exit");

    }





}

