///  point_in_line_segment: returns true iff (x,y) lies within 
///   distance "threshold" of the line segment <(x1,y1), (x2,y2)>

static bool point_in_line_segment (int x, int y, 
				   int x1, int y1, int x2, int y2,
				   int threshold)
{
  int left, right, top, bottom;
  if (x1 < x2) {
    left = x1; right = x2;
  }
  else {
    left = x2; right = x1;
  }
  if (y1 < y2) {
    top = y1; bottom = y2;
  }
  else {
    top = y2; bottom = y1;
  }
  
  // do simple bounding box test first
  if (x < left-threshold || x > right+threshold ||
      y < top-threshold || y > bottom+threshold) {
    return false;
  }

  // The old line hit formula.  Seems to work okay.
  
  // equation for line is ax + by + c = 0
  // d/sqrt(a^2+b^2) is the distance between line and point <x,y>
  long a = y1 - y2; //long type needed for Windows
  long b = x2 - x1;
  float c = (float)(long(x1)*y2 - long(x2)*y1);
  float d = ((float)a)*x + ((float)b)*y + c;
  
  return (d*d <= long(threshold) * threshold * (a*a + b*b));
}
