import java.awt.Rectangle;
import java.util.List;
import java.awt.Point;

public interface Group extends GraphicalObject {

    public void addChild (GraphicalObject child);
    public void removeChild (GraphicalObject child);
    public void bringChildToFront (GraphicalObject child);
    public void resizeChild (GraphicalObject child);
    public void resizeToChildren ();
    public void damage (Rectangle rectangle);
    public Point parentToChild (Point pt);
    public Point childToParent (Point pt);
    public List getChildren ();

    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;

}

