import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

public class TestFrame extends JFrame implements Group {

    private Image buffer;
    private JComponent canvas;
    private JTextArea message;

    public TestFrame (String title, int width, int height) {
        super (title);

        MouseListener ml = new MouseAdapter () {
                public void mousePressed (MouseEvent event) {
                    unpause ();
                }
            };
        addMouseListener (ml);

        addWindowListener (new WindowAdapter () {
                public void windowClosing (WindowEvent event) {
                    System.exit (0);
                }
            });

        Container content = getContentPane ();
        content.setLayout (new BorderLayout ());

        canvas = new JComponent () {
                public void paintComponent (Graphics g) {
                    if (buffer != null)
                        g.drawImage (buffer, 0, 0, null);
                }
            };
        canvas.setBackground (Color.white);
        canvas.setPreferredSize (new Dimension (width, height));
        content.add (BorderLayout.CENTER, canvas);

        message = new JTextArea (10, 40);
        message.setEditable (false);
        message.addMouseListener (ml);
        content.add (BorderLayout.SOUTH, new JScrollPane (message));
    
        pack ();
        show ();

        makeBuffer (width, height); // must be after show()
    }

    //
    // Drawing GraphicalObjects in the window.
    //

    public void redraw (GraphicalObject gobj) {
        Graphics2D g = (Graphics2D) buffer.getGraphics ();
        gobj.draw (g);
        canvas.repaint ();
    }

    private void makeBuffer (int width, int height) {
        buffer = createImage (width, height);
        Graphics2D g = (Graphics2D) buffer.getGraphics ();
        g.setColor (canvas.getBackground ());
        g.fillRect (0, 0, width, height);
    }


    //
    // Group interface
    //

    // This class is NOT a correct implementation of Group.
    // It's just a test harness that displays GraphicalObjects
    // in a window.
    Hashtable children = new Hashtable ();

    public void addChild (GraphicalObject child) {
        child.setGroup (this);
        redraw (child);

        // put child in a hash table just to keep it from
        // being garbage-collected
        children.put (child, child); 
    }
    public void removeChild (GraphicalObject child) {
    }
    public void bringChildToFront (GraphicalObject child) {
    }
    public void resizeChild (GraphicalObject child) {
    }
    public void resizeToChildren () {
    }
    public void damage (Rectangle rectangle) {
        Graphics2D g = (Graphics2D) buffer.getGraphics ();
        g.setColor (canvas.getBackground ());
        g.fill (rectangle);
    }
    public void draw (Graphics2D graphics) {
    }
    public Rectangle getBoundingBox () {
        return canvas.getBounds ();
    }
    public void moveTo (int x, int y) {
    }
    public Group getGroup () {
        return null;
    }
    public void setGroup (Group group) {
    }


    // 
    // Message output
    //

    public void print (Object msg) {
        message.append (msg.toString ());
        message.setCaretPosition (message.getDocument ().getLength ());
    }

    public void println (Object msg) {
        print (msg + "\n");
    }

    // 
    // Sleeping
    //

    public void sleep (int msec) {
        try {
            Thread.sleep (msec);
        } catch (InterruptedException e) {
        }
    }

    //
    // Waiting for mouse clicks
    //

    public void pause () {
        println ("click to continue...");
        synchronized (this) {
            try {
                wait ();
            } catch (InterruptedException e) {
            }
        }
    }

    public void unpause () {
        synchronized (this) {
            notify ();
        }
    }


    //
    // Random selections
    //

    private static Random r = new Random ();

    public int random (int n) {
        return r.nextInt (n);
    }

    public Object random (Object[] things) {
        return things[random (things.length)];
    }


    //
    // Loading images from disk
    // Guarantees that the image is loaded, so you don't have to pass
    // an ImageObserver when you call getWidth(), getHeight(), or
    // drawImage().
    // 

    private MediaTracker tracker = new MediaTracker (new Label (""));
    private int nextID = 0;

    public Image loadImageFully (String filename) {
        Image image = getToolkit ().getImage (filename);
        int id = nextID++;
        tracker.addImage (image, id);
        try {
            try {
                tracker.waitForID (id);
            } finally {
                tracker.removeImage (image);
            }
        } catch (InterruptedException e) {
        }
        return image;
    }

}
