import java.awt.*;

public class Text implements GraphicalObject
{
    int x,y;
    String text;
    Font font;
    Color color;
    Group myGroup;

    public Text(String text,int x, int y, Font font, Color color)
    {
        this.x = x;
        this.y = y;
        this.text = text;
        this.font = font;
        this.color = color;
        myGroup = null;
    }

    public int getX()
    {
        return x;
    }

    public int getY()
    {
        return y;
    }

    public String getText()
    {
        return text;
    }

    public Font getFont()
    {
        return font;
    }

    public Color getColor()
    {
        return color;
    }

    public void setX(int x)
    {
        if(this.x != x)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            this.x = x;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setY(int y)
    {
        if(this.y != y)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            this.y = y;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setText(String text)
    {
        if (myGroup != null)
        {
            myGroup.damage(getBoundingBox());
        }
        this.text = text;
        if (myGroup != null)
        {
            myGroup.damage(getBoundingBox());
            myGroup.resizeChild(this);
        }
    }

    public void setFont(Font font)
    {
        if (myGroup != null)
        {
            myGroup.damage(getBoundingBox());
        }
        this.font = font;
        if (myGroup != null)
        {
            myGroup.damage(getBoundingBox());
            myGroup.resizeChild(this);
        }
    }

    public void setColor(Color color)
    {
        this.color = color;        
        if (myGroup != null)
        {
            myGroup.damage(getBoundingBox());
        }
    }

    public void draw(Graphics2D graphics) 
    {
        graphics.setFont(font);
        graphics.setPaint(color);
        graphics.drawString(text, x,y);
    }

    //attempt to get a close box....not that close, but i dont think exact is possible if you want it to be generalizable
    public Rectangle getBoundingBox() 
    {
        FontMetrics fm = java.awt.Toolkit.getDefaultToolkit().getFontMetrics(font);
        return new Rectangle(x,y-fm.getAscent(),fm.stringWidth(text),fm.getAscent()+fm.getDescent());
    }

    public void moveTo(int x, int y) 
    {
        FontMetrics fm = java.awt.Toolkit.getDefaultToolkit().getFontMetrics(font);
        if(this.x != x || this.y-fm.getAscent()-fm.getLeading() != y)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            this.x = x;
            this.y = y+fm.getAscent();
            if (myGroup != null)
            {         
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public Group getGroup() 
    {
        return myGroup;
    }

    public void setGroup(Group group) 
    {
	myGroup = group;
	/*  setGroup only called by a group object, so the following
	 ** is unnecessary 
        if (group != myGroup)
        {
            if (myGroup != null)
            {
                myGroup.removeChild(this);
            }
            myGroup = group;
            group.addChild(this);
        }
	*/
    }
}

