import java.awt.*;

public class TestLine extends TestFrame {

    public static void main (String[] args) {
        new TestLine (args);
    }

    public TestLine (String[] args) {
        super ("TestLine", 200, 200);

        int lineThickness = 1;
        try {
            lineThickness = Integer.parseInt (args[0]);
            println ("line thickness = " + lineThickness);
        } catch (Exception e) {
            println ("usage:  TestRect [line thickness]\n"
                                + "using line thickness = "
                                + lineThickness + " by default"); 
        }

        println ("creating Rect");
        //Rect r = new Rect (10, 10, 50, 50, Color.red, lineThickness);
        Line r = new Line(5,5,60,60,Color.orange,8);
        addChild (r);
        pause ();

        println ("moving rectangle with setX(), setY()");
        for (int x = 10; x < 150; x += 30) {
            r.setX1 (x);
            for (int y = 10; y < 150; y += 30) {
                r.setY1 (y);
                redraw (r);
                sleep (500);
            }
        }
        println ("final bounding box is " + r.getBoundingBox ());
        println ("final x/y position is " 
                            + r.getX1 () + "," + r.getY1 ());
        pause ();

        println ("changing to blue");
        r.setColor (Color.blue);
        redraw (r);
        pause ();

        println ("moving rectangle with moveTo ()");
        for (int x = 10; x < 150; x += 30) {
            for (int y = 10; y < 150; y += 30) {
                r.moveTo (x, y);
                redraw (r);
                sleep (100);
            }
        }
        println ("final bounding box is " + r.getBoundingBox ());
        println ("final x/y position is " 
                            + r.getX1 () + "," + r.getY1 ());
        pause ();

        println ("doubling line thickness to " + lineThickness*2);
        //r.setLineThickness (lineThickness*2);
        redraw (r);
        pause ();

        println ("moving rectangle with moveTo ()");
        for (int x = 10; x < 150; x += 30) {
            for (int y = 10; y < 150; y += 30) {
                r.moveTo (x, y);
                redraw (r);
                sleep (100);
            }
        }
        println ("final bounding box is " + r.getBoundingBox ());
        println ("final x/y position is " 
                            + r.getX1 () + "," + r.getY1 ());

        println ("close the window to exit");
    }


}
