import java.awt.*;


public class TestLayoutFillGroup extends TestFrame {

    public static void main (String[] args) {
        new TestLayoutFillGroup (args);
    }

    public TestLayoutFillGroup (String[] args) {
        super ("TestLayoutGroup", 500, 200);

        int nObjects = 20;
        try {
            nObjects = Integer.parseInt (args[0]);
            println ("nObjects = " + nObjects);
        } catch (Exception e) {
            println ("usage:  TestLayoutGroup [# of graphical objects]\n"
                                + "using " + nObjects + " objects by default");
        }

        println ("creating black frame");
        addChild (new Rect (9, 9, 481, 181, Color.black, 1));

        println ("creating LayoutGroup inside black frame");
        Group group = new LayoutGroup (10, 10, 480, 180,
                                       Group.FILL, 
                                       0);
        addChild (group);
        
        println ("creating random Rects");
        GraphicalObject[] objects = new GraphicalObject[nObjects+2];
        Color[] colors = { Color.black, Color.red, Color.blue };
        for (int i = 0; i < nObjects; ++i) {
            objects[i] = new Rect (random(200), random (200),
                                   30 + random (20), 30+random(20),
                                   (Color) random (colors),random(3));
            group.addChild (objects[i]);
        }

        Line l = new Line(5,5,30,30,Color.orange,8);
        objects[nObjects-1] = l;
        group.addChild(objects[nObjects-1]);

        ScaledGroup sg = new ScaledGroup(50,3,50,50,1,1);
        //SimpleGroup sg = new SimpleGroup(50,3,50,50);
        Rect r = new Rect(0,0,25,25,Color.cyan,3);
        sg.addChild(r);
        objects[nObjects] = sg;
        group.addChild(objects[nObjects]);


        redraw (group);
        pause ();

        //println("scaledgroup bbwidth: " + sg.getBoundingBox().width);


        println("change scale!");
        sg.setScaleX(2.0);
        redraw(group);
        //println("scaledgroup bbwidth: " + sg.getBoundingBox().width);

        pause();
        println ("shuffling rectangles 10 times");
        GraphicalObject front = objects[objects.length - 1];
        for (int i = 0; i < 10; ++i) {
            GraphicalObject gobj;
            while ((gobj = (GraphicalObject) random (objects)) == front)
                ;
            group.bringChildToFront (gobj);
            front = gobj;
            redraw (group);
            pause();
        }

        pause ();
         /*
        println ("doubling rectangle widths");
        for (int i = 0; i < objects.length; ++i) {
            Rect r = (Rect) objects[i];
            r.setWidth (r.getWidth () * 2);
            redraw (group);
            sleep (1000);
        }
        */
        println ("close the window to exit");
    }

}
