import java.awt.*;

public class TestHomework2 extends TestFrame {

    public static void main (String[] args) {
        new TestHomework2 (args);
    }

    public TestHomework2 (String[] args) {
        super ("TestHomework2", 400, 400);

        println ("1. creating blue rect, thick = 4, x,y=0");
	GraphicalObject r = new Rect (0, 0, 50, 80, Color.blue, 4);
        Group group = new SimpleGroup (0, 0, 300, 400);
        addChild (group);
        group.addChild (r);
	redraw (group);

        println ("2. moving to 30,30");
	pause();
	r.moveTo(30,30);
	redraw (group);

	println ("3. remove from group--see if goes away");
	pause();
	group.removeChild (r);
	redraw (group);

	println("4. put back; overlap with a red rectangle");
	pause();
        group.addChild (r);
	Rect r2 = new Rect (10, 20, 50, 80, Color.red, 8);
        group.addChild (r2);
	redraw (group);

	println("5. bring blue to front");
	pause();
	group.bringChildToFront(r);
	redraw (group);

	println("6. moving red rect while behind blue");
	pause();
	r2.moveTo(20,30);
	redraw (group);

	println("7. change color of red rectangle to green");
	pause();
	r2.setColor(Color.green);
	redraw (group);

	println("8. Creating Filled Yellow Rect");
	pause();
	GraphicalObject r3 = new FilledRect (30, 40, 100, 20, Color.yellow);
	group.addChild(r3);
	redraw (group);

	println("9. Putting yellow next to blue");
	pause();
	Rectangle bounds = r.getBoundingBox();
	r3.moveTo(bounds.x+bounds.width, bounds.y+(bounds.height/2));
	redraw (group);

	println("10. creating lines and icons");
	pause();
	
        println ("Line");
        Line line1 = new Line (70, 130, 120, 180, Color.blue, 10);
	group.addChild (line1);
        group.addChild (new Line (10, 130, 10, 180, Color.black, 1));
        group.addChild (new Line (20, 130, 60, 130, Color.red, 3));

        println ("Icon");
	Image duke = loadImageFully ("duke.gif");
        group.addChild (new Icon (duke, 10, 200));
	Icon icon1 = new Icon (loadImageFully ("duke-running.gif"), 80, 200);
        group.addChild (icon1);

	redraw(group);

	println("11. moving blue line behind red line using setX1");
	pause();
	line1.setX1(40);
	line1.setY1(110);
	redraw(group);

	println("12. moving blue line behind black line using moveTo");
	pause();
	line1.moveTo(1, 150);
	redraw(group);

	println("13. moving big icon using setX1");
	pause();
	icon1.setX(30);
	icon1.setY(220);
	redraw(group);
     
 	println("14. moving big icon behind little icon");
	pause();
	icon1.moveTo(30, 220);
	redraw(group);

	println("15. Test group clipping");
	pause();
        group.addChild (new Line (299, 0, 299, 400, Color.black, 1));
	redraw(group);
	println("15a. filledrect");
	pause();
	group.addChild (new FilledRect(250, 100, 100, 40, Color.yellow));
	redraw(group);

	println("15b. line");
	pause();
	group.addChild (new Line (250, 110, 400, 200, Color.green, 4));
	redraw(group);

	println("15c. text");
	pause();
	group.addChild (new Text ("reallyLongStringShouldGetCutOff", 250, 200,
				  new Font ("Serif", Font.BOLD, 20),
				  Color.black));
	redraw(group);
	
	/**/
        Group lg = new LayoutGroup (0, 0, 400, 400, Group.VERTICAL,2);
	println("16. adding r to another group, should crash");
	pause();
	lg.addChild(r); //might crash
	/**/

	println("removing all. Getting ready for different groups");
	removeChild(group);
	pause();

	GraphicalObject la1 = new Rect (0, 0, 50, 80, Color.orange, 4);
	GraphicalObject la2 = new FilledRect (60, 100, 10, 30, Color.yellow);
	GraphicalObject la3 = new Line (10, 200, 70, 20, Color.red, 8);
	GraphicalObject la4 = new Icon (duke, 0, 10);
	GraphicalObject lb1 = new Rect (0, 0, 50, 80, Color.orange, 4);
	GraphicalObject lb2 = new FilledRect (60, 100, 10, 30, Color.yellow);
	GraphicalObject lb3 = new Line (10, 200, 70, 20, Color.red, 8);
	GraphicalObject lb4 = new Icon (duke, 0, 10);

	println("17. adding new objects to simplegroup");
	pause();

        Group topgroup = new SimpleGroup (0, 0, 400, 400);
        addChild (topgroup);
        Group sgroup = new SimpleGroup (10, 10, 200, 400);
	topgroup.addChild(sgroup);
	sgroup.addChild(la1);
	sgroup.addChild(la2);
	sgroup.addChild(la3);
	sgroup.addChild(la4);
	redraw(topgroup);
	
	println("18. adding new objects to layoutgroup");
	pause();
        LayoutGroup layoutgroup = new LayoutGroup (220, 0, 150, 400,
					     Group.VERTICAL, 2);
	layoutgroup.addChild(lb1);
	layoutgroup.addChild(lb2);
	layoutgroup.addChild(lb3);
	layoutgroup.addChild(lb4);
	topgroup.addChild(layoutgroup);
	redraw(topgroup);

	println("19. removing long line from layout group");
	pause();
	layoutgroup.removeChild(lb3);
	redraw(topgroup);

	println("20. moving simple group to right and down");
	pause();
	sgroup.moveTo(30,30);
	redraw(topgroup);

	println("21. changing layout group's offset to 30");
	pause();
	layoutgroup.setOffset(30);
	redraw(topgroup);

	println("22. changing layout group to horizontal at x=10");
	pause();
	layoutgroup.setX(10);
	layoutgroup.setY(200);
	layoutgroup.setLayout(HORIZONTAL);
	redraw(topgroup);
	
	println("23. changing layout group to be wider");
	pause();
	layoutgroup.setWidth(400);
	redraw(topgroup);

	println("24. New scale group with scale = 0.5,1.5");
	pause();
	GraphicalObject lc1 = new Rect (0, 0, 50, 80, Color.orange, 4);
	GraphicalObject lc2 = new FilledRect (60, 100, 10, 30, Color.yellow);
	GraphicalObject lc3 = new Line (10, 200, 70, 20, Color.red, 8);
	GraphicalObject lc4 = new Icon (duke, 0, 10);
	/**/
        ScaledGroup scalegroup = new ScaledGroup (220, 0, 150, 400, 0.5, 1.5);
	/*
        Group scalegroup = new SimpleGroup (220, 0, 150, 400);
	/**/
	scalegroup.addChild(lc1);
	scalegroup.addChild(lc2);
	scalegroup.addChild(lc3);
	scalegroup.addChild(lc4);
	topgroup.addChild(scalegroup);
	redraw(topgroup);
	
	println("25. Change the scale to be even smaller: 0.2, 0.4");
	pause();
	scalegroup.setScaleX(0.2);
	scalegroup.setScaleY(0.4);
	redraw(topgroup);
	pause();

	println("removing all. Getting ready for different groups");
	removeChild(topgroup);
	pause();

	println("26. (Extra credit) Test overlapping regions");
	pause();
	println("26a. first group");
        Group topgroup2 = new SimpleGroup (0, 0, 400, 400);
        addChild (topgroup2);
        Group sgroup2 = new SimpleGroup (10, 10, 200, 400);
	FilledRect ld1 = new FilledRect (30, 20, 70, 150, Color.yellow);
	GraphicalObject ld2 = new FilledRect (10, 60, 110, 70, Color.green);
	sgroup2.addChild(ld1);
	sgroup2.addChild(ld2);
	topgroup2.addChild(sgroup2);
	redraw(topgroup2);

	println("26b. second group");
	pause();
        Group sgroup3 = new SimpleGroup (200, 10, 200, 400);
	FilledRect le1 = new FilledRect (30, 20, 70, 150, Color.yellow);
	GraphicalObject le2 = new FilledRect (10, 60, 110, 70, Color.green);
	sgroup3.addChild(le1);
	sgroup3.addChild(le2);
	topgroup2.addChild(sgroup3);
	redraw(topgroup2);

	println("26c. move second group to be on top of first");
	pause();
	sgroup3.moveTo(35, 35);
	redraw(topgroup2);

	println("26d. change color on top");
	pause();
	le1.setColor(Color.red);
	redraw(topgroup2);

	println("26e. change color on bottom");
	pause();
	ld1.setColor(Color.black);
	redraw(topgroup2);

	println("26f. move on bottom");
	pause();
	ld1.moveTo(15, 10);
	redraw(topgroup2);

        println ("DONE. close the window to stop");
    }

}
