import java.awt.*;
import java.util.*;

public class SimpleGroup implements Group
{
    int x,y, width, height;
    Vector objects;
    Vector damage;
    Vector redraw;
    Group myGroup;

    //i have three vectors:
    //1. all the objects in the group
    //2. all the rectangles used for damage between draws....keeps us from infinite looping
    //3. the redraw status of the objects in the groups

    public SimpleGroup(int x, int y, int width, int height)
    {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        objects = new Vector();
        damage = new Vector();
        redraw = new Vector();
        myGroup = null;
    }

    public int getX()
    {
        return x;
    }

    public int getY()
    {
        return y;
    }

    public int getWidth()
    {
        return width;
    }

    public int getHeight()
    {
        return height;
    }

    public void setX(int newX)
    {
        if(newX != x)
        {
            damage(getBoundingBox());
            x = newX;
            damage(getBoundingBox());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }
    }

    public void setY(int newY)
    {
        if(newY != y)
        {
            damage(getBoundingBox());
            y = newY;
            damage(getBoundingBox());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }
    }

    public void setWidth(int newWidth)
    {
        if(newWidth != width)
        {
            damage(getBoundingBox());
            width = newWidth;
            damage(getBoundingBox());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }

    }

    public void setHeight(int newHeight)
    {
        if(newHeight != height)
        {
            damage(getBoundingBox());
            height = newHeight;
            damage(getBoundingBox());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }

    }

    public void resizeChild(GraphicalObject child) 
    {
        //do nothing special, we don't do dynamic layout in SimpleGroup
    }

    public void addChild(GraphicalObject child) 
    {
        if(!objects.contains(child))
        {
            objects.add(child);
            redraw.add(new Boolean(true));
            child.setGroup(this);
            damage(child.getBoundingBox());
        }
    }

    public void removeChild(GraphicalObject child) 
    {
        if(objects.contains(child))
        {
            int index = objects.indexOf(child);
            objects.remove(index);
            redraw.remove(index);
            child.setGroup(null);
            damage(child.getBoundingBox());
        }
    }

    //Damage method is a pain
    public void damage(Rectangle rectangle)
    {
        //Alright, we assume that the damage is in OUR coordinate system
        //make rectangle to pass up to parent 
        Rectangle goup = (Rectangle)rectangle.clone();
        Rectangle us = getBoundingBox();
        //if this damage doesnt even intersect us, we dont care
        if(rectangle.intersects(us))
        {
            //Pass up
            if(myGroup != null)
            {
                //send up only the part that is within me, since we dont want elements of ours that are
                //not supposed to be drawn to force redraws
                goup = goup.intersection(us);
                //put into parent coordinates
                goup.translate(x,y);
                //send it up
                myGroup.damage(goup);
            }
            //now, for all our children
            for (int i=0; i < objects.size(); i++)
            {
                GraphicalObject child = (GraphicalObject)objects.get(i);
                Rectangle box = child.getBoundingBox();
                //if the damage touches them
                if (box.intersects(rectangle))
                {
                    //set them to be redrawn
                    redraw.set(i,new Boolean(true));
                }
            }
        }
    }

    //just shove it on the end of the vectors
    public void bringChildToFront(GraphicalObject child) 
    {
        if(objects.contains(child))
        {
            int index = objects.indexOf(child);
            objects.remove(index);
            objects.add(child);
            redraw.remove(index);
            redraw.add(new Boolean(true));
            damage(child.getBoundingBox());
        }
    }

    //basically, keep extending the borders untill all children are inside, except the ones negative to us
    public void resizeToChildren() 
    {
        int oldwidth = width;
        int oldheight = height;
        width = 0;
        height = 0;
        for(int i =0; i < objects.size(); i++)
        {
            Rectangle box = ((GraphicalObject)objects.get(i)).getBoundingBox();
            int maxX = (int)box.getMaxX();
            if ( maxX > width) width = maxX;
            int maxY = (int)box.getMaxY();
            if ( maxY > height) height = maxY;
            if ((maxX > oldwidth) || (maxY > oldheight))
            {
                damage(box);
            }
        }
        if ((width != oldwidth || height != oldheight) && myGroup != null)
        {
            damage(getBoundingBox());
            myGroup.resizeChild(this);
        }
    }

    public Group getGroup() 
    {
        return myGroup;
    }

    //translate to our coordinates then clip to us
    //if we arent top level (and we never should be, since we cant draw background!) just draw everything
    //else draw only things that are designated for redraw
    public void draw(Graphics2D graphics) 
    {
        Shape oldclip = graphics.getClip();
        graphics.translate(x,y);
        graphics.setClip(getBoundingBox());
        for (int i=0; i < objects.size(); i++)
        {
            if (((Boolean)redraw.get(i)).booleanValue() == true  || myGroup != null)
            {
                ((GraphicalObject)objects.get(i)).draw(graphics);
                redraw.set(i,new Boolean(false));
            }
        }
        graphics.translate(-x,-y);
        graphics.setClip(oldclip);
        damage = new Vector();
    }

    //its in our coordinate system (very important, especially for scaledlayout)
    public Rectangle getBoundingBox() 
    {
        return new Rectangle(0,0,width,height);
    }

    public void moveTo(int x, int y) 
    {
        damage(getBoundingBox());
        this.x =x;
        this.y =y;
        damage(getBoundingBox());
        if (myGroup != null)
        {
            myGroup.resizeChild(this);
        }
    }

    public void setGroup(Group group) 
    {
        if (group != myGroup)
        {
            if (myGroup != null)
            {
                myGroup.removeChild(this);
            }
            myGroup = group;
            group.addChild(this);
        }
    }

    public Point parentToChild (Point pt) {
        return new Point ((int) (pt.getX () - x), 
                          (int) (pt.getY () - y));
    }

    public Point childToParent (Point pt) {
        return new Point ((int) (pt.getX () + x), 
                          (int) (pt.getY () + y));
    }
}
