import java.awt.*;
import java.util.*;

public class ScaledGroup implements Group
{
    int x,y, width, height;
    Vector objects;
    Vector damage;
    Vector redraw;
    Group myGroup;
    double scaleX, scaleY;

    //i have three vectors:
    //1. all the objects in the group
    //2. all the rectangles used for damage between draws....keeps us from infinite looping
    //3. the redraw status of the objects in the groups


    public ScaledGroup(int x, int y, int width, int height, double scaleX, double scaleY)
    {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        objects = new Vector();
        damage = new Vector();
        redraw = new Vector();
        myGroup = null;
    }

    public int getX()
    {
        return x;
    }

    public int getY()
    {
        return y;
    }

    public int getWidth()
    {
        return width;
    }

    public int getHeight()
    {
        return height;
    }

    public double getScaleX()
    {
        return scaleX;
    }

    public double getScaleY()
    {
        return scaleY;
    }

    public void setX(int newX)
    {
        if(newX != x)
        {
            damage(getBoundingBoxLocal());
            x = newX;
            damage(getBoundingBoxLocal());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }
    }

    public void setY(int newY)
    {
        if(newY != y)
        {
            damage(getBoundingBoxLocal());
            y = newY;
            damage(getBoundingBoxLocal());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }
    }

    public void setWidth(int newWidth)
    {
        if(newWidth != width)
        {
            damage(getBoundingBoxLocal());
            width = newWidth;
            damage(getBoundingBoxLocal());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }
    }

    public void setHeight(int newHeight)
    {
        if(newHeight != height)
        {
            damage(getBoundingBoxLocal());
            height = newHeight;
            damage(getBoundingBoxLocal());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }
    }

    public void setScaleX(double newScaleX)
    {
        if(newScaleX != scaleX)
        {
            damage(getBoundingBoxLocal());
            scaleX = newScaleX;
        }
    }

    public void setScaleY(double newScaleY)
    {
        if(newScaleY != scaleY)
        {
            damage(getBoundingBoxLocal());
            scaleY = newScaleY;
        }
    }

    public void resizeChild(GraphicalObject child) 
    {
        //do nothing special, we don't do dynamic layout in ScaledGroup
    }

    public void addChild(GraphicalObject child) 
    {
        if(!objects.contains(child))
        {
            objects.add(child);
            redraw.add(new Boolean(true));
            child.setGroup(this);
            damage(child.getBoundingBox());
        }
    }

    public void removeChild(GraphicalObject child) 
    {
        if(objects.contains(child))
        {
            int index = objects.indexOf(child);
            objects.remove(index);
            redraw.remove(index);
            child.setGroup(null);
            damage(child.getBoundingBox());
        }
    }

    //Damage method is a pain
    public void damage(Rectangle rectangle)
    {
        //Alright, we assume that the damage is in OUR coordinate system
        //make rectangle to pass up to parent 
        Rectangle goup = (Rectangle)rectangle.clone();
        Rectangle us = new Rectangle(0,0,width,height);
        //if this damage doesnt even intersect us, we dont care
        if(rectangle.intersects(us))
        {
            //Pass up
            if(myGroup != null)
            {
                double x1 = goup.getX()*scaleX;
                double y1 = goup.getY()*scaleY;
                double x2 = x1 + goup.getWidth()*scaleX;
                double y2 = y1 + goup.getHeight()*scaleY;
                x1 = Math.floor (x1);
                y1 = Math.floor (y1);
                x2 = Math.ceil (x2);
                y2 = Math.ceil (y2);
                goup.setBounds ((int) x1, (int) y1, 
                                (int) (x2-x1), (int) (y2-y1));

                //send up only the part that is within me, since we dont want elements of ours that are
                //not supposed to be drawn to force redraws
                goup = goup.intersection(us);
                //put into parent coordinates
                goup.translate(x,y);
                //send it up
                myGroup.damage(goup);
            }
            //now, for all our children
            //NOTE: dont need to scale, since this is just a comparison, and the damage, since it only goes upwards
            //is in the same coordinate system as the children already
            for (int i=0; i < objects.size(); i++)
            {
                GraphicalObject child = (GraphicalObject)objects.get(i);
                Rectangle box = child.getBoundingBox();
                //if the damage touches them
                if (box.intersects(rectangle))
                {
                    //set them to be redrawn
                    redraw.set(i,new Boolean(true));
                }
            }
        }
    }

    public void bringChildToFront(GraphicalObject child) 
    {
        if(objects.contains(child))
        {
            int index = objects.indexOf(child);
            objects.remove(index);
            objects.add(child);
            redraw.remove(index);
            redraw.add(new Boolean(true));
            damage(child.getBoundingBox());
        }
    }

    //same as others except you have to scale the children
    public void resizeToChildren() 
    {
        int oldwidth = width;
        int oldheight = height;
        width = 0;
        height = 0;
        for(int i =0; i < objects.size(); i++)
        {
            Rectangle box = ((GraphicalObject)objects.get(i)).getBoundingBox();
            box.setBounds((int)Math.ceil((box.getX()*scaleX)),(int)Math.ceil((box.getY()*scaleY)),
                          (int)Math.ceil((box.getWidth()*scaleX)),(int)Math.ceil((box.getHeight()*scaleY)));
            int maxX = (int)box.getMaxX()/2;
            if ( maxX > width) width = maxX;
            int maxY = (int)box.getMaxY()/2;
            if ( maxY > height) height = maxY;
            if ((maxX > oldwidth) || (maxY > oldheight))
            {
                damage(box);
            }
        }
        if ((width != oldwidth || height != oldheight) && myGroup != null)
        {
            damage(getBoundingBoxLocal());
            myGroup.resizeChild(this);
        }
    }

    public Group getGroup() 
    {
        return myGroup;
    }

    //translate to our coordinates then clip to us and then scale everything after that
    //if we arent top level (and we never should be, since we cant draw background!) just draw everything
    //else draw only things that are designated for redraw
    public void draw(Graphics2D graphics) 
    {
        Shape oldclip = graphics.getClip();
        graphics.translate(x,y);
        graphics.setClip(0,0,width,height);
        graphics.scale(scaleX,scaleY);
        for (int i=0; i < objects.size(); i++)
        {
            if (((Boolean)redraw.get(i)).booleanValue() == true  || myGroup != null)
            {
                ((GraphicalObject)objects.get(i)).draw(graphics);
                redraw.set(i,new Boolean(false));
            }
        }
        graphics.scale(1/scaleX,1/scaleY);
        graphics.translate(-x,-y);
        graphics.setClip(oldclip);
        damage = new Vector();          
    }

    //its in our coordinate system (very important, especially for scaledlayout)
    public Rectangle getBoundingBox() 
    {
        return new Rectangle(0,0,width,height);
    }

    //when we send outselves up as damage, we need to send a scaled version of our bounding box, as it will be rescaled
    //in the damage function
    Rectangle getBoundingBoxLocal()
    {
        return new Rectangle(0,0,(int)Math.ceil(width/scaleX),(int)Math.ceil(height/scaleY));
    }

    public void moveTo(int x, int y) 
    {
        damage(getBoundingBoxLocal());
        this.x =x;
        this.y =y;
        damage(getBoundingBoxLocal());
        if (myGroup != null)
        {
            myGroup.resizeChild(this);
        }
    }

    public void setGroup(Group group) 
    {
        if (group != myGroup)
        {
            if (myGroup != null)
            {
                myGroup.removeChild(this);
            }
            myGroup = group;
            group.addChild(this);
        }
    }


    public Point parentToChild (Point pt) {
        return new Point ((int) ((pt.getX () - x) / scaleX), 
                          (int) ((pt.getY () - y) / scaleY));
    }

    public Point childToParent (Point pt) {
        return new Point ((int) ((pt.getX () * scaleX) + x), 
                          (int) ((pt.getY () * scaleY) + y));
    }
}

