import java.awt.*;       
       
       
public class Rect extends Object implements GraphicalObject
{
    int x, y;
    int width, height;
    Color color; 
    int lineThickness;
    Group myGroup;


    public Rect(int x, int y, int width, int height, Color color, int lineThickness)
    {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
        this.lineThickness = lineThickness;
        myGroup = null;
    }

    public int getX()
    {
        return x;
    }

    public int getY()
    {
        return y;
    }
    
    public int getWidth()
    {
        return width;
    }
    
    public int getHeight()
    {
        return height;
    }

    public Color getColor()
    {
        return color;
    }

    public int getLineThickness()
    {
        return lineThickness;
    }

    public void setX(int newX)
    {
        if(newX != x)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            x = newX;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setY(int newY)
    {
        if(newY != y)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            y = newY;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setWidth(int newWidth)
    {
        if(newWidth != width)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            width = newWidth;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setHeight(int newHeight)
    {
        if(newHeight != height)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            height = newHeight;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setColor(Color newColor)
    {
        color = newColor;
        if (myGroup != null)
        {
            myGroup.damage(getBoundingBox());
        }
    }

    public void setLineThickness(int newLineThickness)
    {
        if(newLineThickness != lineThickness)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            lineThickness = newLineThickness;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    //square and miter make nice rectangles
    public void draw(Graphics2D graphics)
    {
        graphics.setStroke(new BasicStroke(lineThickness,BasicStroke.CAP_SQUARE,BasicStroke.JOIN_MITER));
        graphics.setPaint(color);
        graphics.drawRect(x,y,width,height);
    }

    //a bit of calculations for the width of the lines
    public Rectangle getBoundingBox()
    {
        return new Rectangle(x- (int)Math.floor(lineThickness/2.0),y- (int)Math.floor(lineThickness/2.0),
                             width+ lineThickness, height+ lineThickness);
    }

    public void moveTo(int x, int y)
    {
        if(this.x != x || this.y != y)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            this.x = x+ (int)Math.floor(lineThickness/2.0);
            this.y = y+ (int)Math.floor(lineThickness/2.0);
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public Group getGroup()
    {
        return myGroup;
    }

    public void setGroup(Group group)
    {
	myGroup = group;
	/*  setGroup only called by a group object, so the following
	 ** is unnecessary 
        if (group != myGroup)
        {
            if (myGroup != null)
            {
                myGroup.removeChild(this);
            }
            myGroup = group;
            group.addChild(this);
        }
	*/
    }
}

