import java.awt.*;       
       
       
public class Line extends Object implements GraphicalObject
{
    int x1, y1, x2, y2;
    Color color; 
    int lineThickness;
    Group myGroup;


    public Line(int x1, int y1, int x2, int y2, Color color, int lineThickness)
    {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.color = color;
        this.lineThickness = lineThickness;
        myGroup = null;
    }

    public int getX1()
    {
        return x1;
    }

    public int getY1()
    {
        return y1;
    }

    public int getX2()
    {
        return x2;
    }

    public int getY2()
    {
        return y2;
    }

    public int getLineThickness()
    {
        return lineThickness;
    }

    public Color getColor()
    {
        return color;
    }

    public void setX1(int newX1)
    {
        if(x1 != newX1)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            x1 = newX1;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setY1(int newY1)
    {
        if(y1 != newY1)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            y1 = newY1;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setX2(int newX2)
    {
        if(x2 != newX2)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            x2 = newX2;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setY2(int newY2)
    {
        if(y2 != newY2)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            y2 = newY2;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setColor(Color newColor)
    {
        color = newColor;
        if (myGroup != null)
        {
            myGroup.damage(getBoundingBox());
        }
    }

    public void setLineThickness(int newLineThickness)
    {
        if(newLineThickness != lineThickness)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            lineThickness = newLineThickness;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    //i chose to use the Round cap, as it made accurate bounding box calculations feasable
    public void draw(Graphics2D graphics)
    {
        graphics.setStroke(new BasicStroke((float)lineThickness,BasicStroke.CAP_ROUND,BasicStroke.JOIN_MITER));
        graphics.setPaint(color);
        graphics.drawLine(x1,y1,x2,y2);
    }

    public Rectangle getBoundingBox()
    {
        //the end is round, and the radius is half the line thickness rounded down.
        return new Rectangle(Math.min(x1,x2)-(int)Math.ceil((lineThickness/2.0)),
                             Math.min(y1,y2)-(int)Math.floor((lineThickness/2.0)),
                             Math.max(x1-x2,x2-x1)+lineThickness+1,
                             Math.max(y1-y2,y2-y1)+lineThickness+1);
    }

    //use the bounding box to figure out where the upper left corner is
    public void moveTo(int x, int y)
    {
        if(x1 != x || y1 != y)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            Rectangle box = getBoundingBox();
            int deltax = x -(int)box.getX();
            int deltay = y -(int)box.getY();
            x1 += deltax;
            x2 += deltax;
            y1 += deltay;
            y2 += deltay;

            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);            
            }
        }
    }

    public Group getGroup()
    {
        return myGroup;
    }

    public void setGroup(Group group)
    {
	myGroup = group;
	/*  setGroup only called by a group object, so the following
	 ** is unnecessary 
        if (group != myGroup)
        {
            if (myGroup != null)
            {
                myGroup.removeChild(this);
            }
            myGroup = group;
            group.addChild(this);
        }
	*/
    }
}



