import java.awt.*;
import java.util.*;



//okay, for layouts i FORCE all child objects into the layouts....
//so if you move one, I move it right back into the layout

public class LayoutGroup implements Group
{

    int x,y,width,height,layout,offset;
    Group myGroup;
    Vector objects, redraw, damage;
    boolean doingLayout;

    //i have three vectors:
    //1. all the objects in the group
    //2. all the rectangles used for damage between draws....keeps us from infinite looping
    //3. the redraw status of the objects in the groups

    public LayoutGroup (int x, int y, int width, int height, int layout, int offset)
    {
        this.x =x;
        this.y =y;
        this.width =width;
        this.height =height;
        this.layout =layout;
        this.offset =offset;
        objects = new Vector();
        redraw = new Vector();
        damage = new Vector();
        myGroup = null;
        doingLayout = false;
    }

    public int getX()
    {
        return x;
    }

    public int getY()
    {
        return y;
    }

    public int getWidth()
    {
        return width;
    }

    public int getHeight()
    {
        return height;
    }

    public int getLayout()
    {
        return layout;
    }

    public int getOffset()
    {
        return offset;
    }

    public void setX(int newX)
    {
        if(newX != x)
        {
            damage(getBoundingBox());
            x = newX;
            damage(getBoundingBox());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }
    }

    public void setY(int newY)
    {
        if(newY != y)
        {
            damage(getBoundingBox());
            y = newY;
            damage(getBoundingBox());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }
    }

    public void setWidth(int newWidth)
    {
        if(newWidth != width)
        {
            damage(getBoundingBox());
            width = newWidth;
            damage(getBoundingBox());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }
    }

    public void setHeight(int newHeight)
    {
        if(newHeight != height)
        {
            damage(getBoundingBox());
            height = newHeight;
            damage(getBoundingBox());
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }

    }


    //function that sets up the layout
    //basically, if the layout is horizontal, start at 0,0 and start placing things
    //after every thing add the width of the old thing plus the offset to the x location for the next thing
    //for vertical, do the same except with height and y 
    void doLayout()
    {
        if(doingLayout == true) return;
        int xlayout =0;
        int ylayout =0;
        doingLayout = true;
        if (layout == FILL)
        {
            /*
            Extra Credit - Fill layout
            The big problem is things that don't fit. If we run out of room, we stop drawing basically....
            So on the first thing that runs out of room, we stop 
    
            Basically, it is a left-right, top-bottom layout....once we find an item that cant fit, we stop.
            */
            int biggestHeight =0;
            int i;
            for(i =0; i < objects.size(); i++)
            {
                //System.out.println("i: " + i);
                //System.out.println("xlayout: " + xlayout + " ylayout: " + ylayout);
                GraphicalObject object = (GraphicalObject)objects.get(i);
                if (object.getBoundingBox().getWidth() <= width -xlayout)
                {
                    //if it fits horizontally
                    if(object.getBoundingBox().getHeight() <= height-ylayout)
                    {
                        //if it fits vertically
                        object.moveTo(xlayout,ylayout);
                        xlayout += offset + object.getBoundingBox().getWidth();
                        if (object.getBoundingBox().getHeight() > biggestHeight)
                        {
                            biggestHeight = (int)object.getBoundingBox().getHeight();
                        }
                    }
                    else
                    {
                        //stop....if we cant fit things vertically, we dont have any room
                        break;
                    }
                } 
                else
                {
                    //if it doesnt fit horizontally, move down
                    //but, if it also doesnt fit vertically give up
                    if(!(object.getBoundingBox().getHeight() <= height-ylayout)) break;
                    xlayout = 0;
                    //dont want them to overlap
                    ylayout += offset + biggestHeight;
                    biggestHeight = 0;
                    //and repeat the last thing
                    i--;
                }
            }
            //take the rest of them and throw them outside the clipping rectangle for this group
            for (; i < objects.size(); i++)
            {
                GraphicalObject object = (GraphicalObject)objects.get(i);
                object.moveTo(width+5,height+5);
            }
        }
        else
        {
            for(int i =0; i < objects.size(); i++)
            {
                GraphicalObject object = (GraphicalObject)objects.get(i);
                object.moveTo(xlayout,ylayout);
                if (layout == HORIZONTAL)
                {
                    xlayout += offset + (int)object.getBoundingBox().getWidth();
                }
                else if (layout == VERTICAL)
                {
                    ylayout += offset + (int)object.getBoundingBox().getHeight();
                }
            }
        }
        damage(getBoundingBox());
        doingLayout = false;
    }

    public void setLayout(int newLayout)
    {
        if (newLayout != layout)
        {
            layout = newLayout;
            doLayout();
            if (myGroup != null)
            {
                myGroup.resizeChild(this);
            }
        }
    }

    public void setOffset(int newOffset)
    {
        if (newOffset != offset)
        {
            offset = newOffset;
            doLayout();
        }
    }

    public void resizeChild(GraphicalObject child)
    {
        //force it into the layout
        doLayout();
    }

    public void addChild(GraphicalObject child)
    {
        if(!objects.contains(child))
        {
            objects.add(child);
            redraw.add(new Boolean(true));
            child.setGroup(this);
        }
        doLayout();
    }

    public void removeChild(GraphicalObject child)
    {
        if(objects.contains(child))
        {
            int index = objects.indexOf(child);
            objects.remove(index);
            child.setGroup(null);
            redraw.remove(index);
        }
        doLayout();
    }

    
    //Damage method is a pain
    public void damage(Rectangle rectangle)
    {
        //Alright, we assume that the damage is in OUR coordinate system
        //make rectangle to pass up to parent 
        Rectangle goup = (Rectangle)rectangle.clone();
        Rectangle us = getBoundingBox();
        //if this damage doesnt even intersect us, we dont care
        if(rectangle.intersects(us))
         {
            //Pass up
            if(myGroup != null)
            {
                //send up only the part that is within me, since we dont want elements of ours that are
                //not supposed to be drawn to force redraws
                goup = goup.intersection(us);
                //put into parent coordinates
                goup.translate(x,y);
                //send it up
                myGroup.damage(goup);
            }
            //now, for all our children
            for (int i=0; i < objects.size(); i++)
            {
                GraphicalObject child = (GraphicalObject)objects.get(i);
                Rectangle box = child.getBoundingBox();
                //if the damage touches them
                if (box.intersects(rectangle))
                {
                    //set them to be redrawn
                    redraw.set(i,new Boolean(true));
                }
            }
        }
    }
    

    public void bringChildToFront(GraphicalObject child)
    {
        if(objects.contains(child))
        {
            int index = objects.indexOf(child);
            objects.remove(index);
            objects.add(child);
            redraw.remove(index);
            redraw.add(new Boolean(true));
        }
        doLayout();
    }


    // make the group really wide or really tall basically
    public void resizeToChildren()
    {
        int oldwidth = width;
        int oldheight = height;
        doLayout();
        width = 0;
        height = 0;
        for(int i =0; i < objects.size(); i++)
        {
            Rectangle box = ((GraphicalObject)objects.get(i)).getBoundingBox();
            int maxX = (int)box.getMaxX();
            int maxY = (int)box.getMaxY();
            if (layout == HORIZONTAL || layout == FILL)
            {
               width += maxX;
               if ( maxY > height) height = maxY;
            }
            if (layout == VERTICAL)
            {
               height += maxY;
               if ( maxX > width) width = maxX;
            }
            
            if ((maxX > oldwidth) || (maxY > oldheight))
            {
                damage(box);
            }
        }
        //add in space for offset
        if (layout == HORIZONTAL || layout ==FILL) width += Math.max(offset*(objects.size()-1),0);
        if (layout == VERTICAL) height += Math.max(offset*(objects.size()-1),0);
        if ((width != oldwidth || height != oldheight) && myGroup != null)
        {
            myGroup.resizeChild(this);
        }
        doLayout();
    }

    public Group getGroup()
    {
        return myGroup;
    }

    //translate to our coordinates then clip to us
    //if we arent top level (and we never should be, since we cant draw background!) just draw everything
    //else draw only things that are designated for redraw
    public void draw(Graphics2D graphics)
    {
        Shape oldclip =  graphics.getClip();
        graphics.translate(x,y);
        graphics.setClip(getBoundingBox());
        for (int i=0; i < objects.size(); i++)
        {
            if (((Boolean)redraw.get(i)).booleanValue() == true || myGroup != null)
            {
                ((GraphicalObject)objects.get(i)).draw(graphics);
                redraw.set(i,new Boolean(false));
            }
        }
        graphics.translate(-x,-y);
        graphics.setClip(oldclip);
        damage = new Vector();
    }

    //its in our coordinate system (very important, especially for scaledlayout)
    public Rectangle getBoundingBox()
    {
        return new Rectangle(0,0,width,height);
    }

    public void moveTo(int x, int y)
    {
        damage(getBoundingBox());
        this.x =x;
        this.y =y;
        damage(getBoundingBox());
        if (myGroup != null)
        {
            myGroup.resizeChild(this);
        }
    }

    public void setGroup(Group group)
    {
        if (group != myGroup)
        {
            if (myGroup != null)
            {
                myGroup.removeChild(this);
            }
            myGroup = group;
            group.addChild(this);
        }
    }

    public Point parentToChild (Point pt) {
        return new Point ((int) (pt.getX () - x), 
                          (int) (pt.getY () - y));
    }

    public Point childToParent (Point pt) {
        return new Point ((int) (pt.getX () + x), 
                          (int) (pt.getY () + y));
    }
}
