import java.awt.*;


//very simple
public class Icon implements GraphicalObject
{
    int x,y;
    Image image;
    Group myGroup;

    public Icon(Image image, int x, int y)
    {
        this.x = x;
        this.y = y;
        this.image = image;
        myGroup = null;
    }

    public int getX()
    {
        return x;
    }

    public int getY()
    {
        return y;
    }

    public Image getImage()
    {
        return image;
    }

    public void setX(int x)
    {
        if(this.x != x)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            this.x = x;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setY(int y)
    {
        if(this.y != y)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            this.y = y;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setImage(Image image)
    {
        this.image = image;
        if (myGroup != null)
        {
            myGroup.damage(getBoundingBox());
        }
    }

    public void draw(Graphics2D graphics) 
    {
        graphics.drawImage(image,x,y,null);
    }

    public Rectangle getBoundingBox() 
    {
        return new Rectangle(x,y,image.getWidth(null),image.getHeight(null));
    }

    public void moveTo(int x, int y) 
    {
        if (this.x != x || this.y !=y)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            this.x = x;
            this.y = y;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public Group getGroup() 
    {
        return myGroup;
    }

    public void setGroup(Group group) 
    {
	myGroup = group;
	/*  setGroup only called by a group object, so the following
	 ** is unnecessary 
        if (group != myGroup)
        {
            if (myGroup != null)
            {
                myGroup.removeChild(this);
            }
            myGroup = group;
            group.addChild(this);
        }
	*/
    }
}
