import java.awt.*;       
       
/*
Filled Rectangle. Nothing really special here
*/       


public class FilledRect extends Object implements GraphicalObject
{
    int x, y;
    int width, height;
    Color color; 
    Group myGroup;


    public FilledRect(int x, int y, int width, int height, Color color)
    {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
        myGroup = null;
    }

    public int getX()
    {
        return x;
    }

    public int getY()
    {
        return y;
    }
    
    public int getWidth()
    {
        return width;
    }
    
    public int getHeight()
    {
        return height;
    }

    public Color getColor()
    {
        return color;
    }

    public void setX(int newX)
    {
        if (x != newX)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            x = newX;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setY(int newY)
    {
       if (y != newY)
       {
           if (myGroup != null)
           {
               myGroup.damage(getBoundingBox());
           }
           y = newY;
           if (myGroup != null)
           {
               myGroup.damage(getBoundingBox());
               myGroup.resizeChild(this);
           }
       }
    }

    public void setWidth(int newWidth)
    {
        if(width != newWidth)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            width = newWidth;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setHeight(int newHeight)
    {
        if(height != newHeight)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
            }
            height = newHeight;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public void setColor(Color newColor)
    {
        color = newColor;
        if (myGroup != null)
        {
            myGroup.damage(getBoundingBox());
        }
    }

    public void draw(Graphics2D graphics)
    {
        graphics.setPaint(color);
        graphics.fillRect(x,y,width,height);
    }

    public Rectangle getBoundingBox()
    {
        return new Rectangle(x,y,width, height);
    }

    public void moveTo(int x, int y)
    {
        if (x != this.x || y != this.y)
        {
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());   
            }
            this.x = x;
            this.y = y;
            if (myGroup != null)
            {
                myGroup.damage(getBoundingBox());
                myGroup.resizeChild(this);
            }
        }
    }

    public Group getGroup()
    {
        return myGroup;
    }

    public void setGroup(Group group)
    {
	myGroup = group;
	/*  setGroup only called by a group object, so the following
	 ** is unnecessary 
        if (group != myGroup)
        {
            if (myGroup != null)
            {
                myGroup.removeChild(this);
            }
            myGroup = group;
            group.addChild(this);
        }
	*/
    }
}


