# Recitation 3: Dynamic semantics practice

- author: Sam Estep <https://samestep.com/>

In this recitation, we'll do a few things:

- review substitution and shadowing
- introduce SASyLF's features for variable binding
- look at modeling semantics of a small language in SASyLF
- add `let` to the language and repair a simple proof

Recitation slides can be found [here](https://docs.google.com/presentation/d/12k-fDTjcMWaLIXDTfXmvct7xPaDKKwMTL0ETilASADc/edit?usp=sharing).

## Structure

The structure of this recitation is similar to that of the previous recitation:

    recitation03
    ├── .project
    ├── .settings
    │   ├── org.eclipse.core.resources.prefs
    │   └── org.sasylf.prefs
    ├── README.md
    └── slf
        └── edu
            └── cmu
                └── cs
                    └── plp
                        └── recitation3.slf

Their purposes are as follows:

- `README.md` is this file.
- `.project` and `.settings` are used by Eclipse.
- `slf/edu/cmu/cs/plp/recitation3.slf` is the file we'll be exploring in this
  recitation.

## Exercise

SASyLF should give no errors or warnings about the version of `recitation3.slf`
you were given. Our goal is to add one more syntactic case for expressions:

    let x = e in e[x]

This in and of itself shouldn't break our (incomplete) proof of
`eval-always-value`, which uses induction over derivations instead of induction
over syntax. Next, we need to add 1 rule to the `eval` judgment and 2 rules to
the `reduce` judgment (to give semantics to the new syntactic rule we've just
added), which _will_ break the proof. Finally, we complete the proof.

## Exploration

Which do you personally like better, big-step or small-step semantics? Is one of
these kinds of semantics objectively better to the other? Why or why not?
