# Recitation 2: The SASyLF Proof Assistant

- authors:
  - Sam Estep <https://samestep.com/>
  - Bradley Teo <bradleyt@andrew.cmu.edu>

In this recitation, we'll introduce the SASyLF proof assistant and use it to
prove the theorem about counting literals and operators which you saw in the
most recent class session.

Next, we'll try to prove some more theorems about the naturals, introducing the
concepts of case analysis and inversion.

## Install SASyLF

Before recitation, you should install SASyLF on your machine,
to ensure that you are able to use it locally.  It's easiest to
use SASyLF from an IDE like VSCode or Eclipse.

For VSCode, first download and run VSCode from
https://code.visualstudio.com/download. Click on the Extensions
button on the left--it has 4 boxes with one offset.  Type SASyLF
in the Extensions search box.  Click Install to install the SASyLF
language server.

For Eclipse, the installation instructions are here:

https://github.com/boyland/sasylf/wiki/Install

You can reference SASyLF's other documentation/exercises/examples to start
familiarizing yourself with it more:

- https://github.com/boyland/sasylf/wiki/Main
- https://github.com/boyland/sasylf/wiki/Proofs
- https://github.com/boyland/sasylf/wiki/Running-SASyLF
- https://github.com/boyland/sasylf/blob/v1.5.1/exercises/exercise1.slf

## Structure

You should have a `recitation02.zip` file. Upon unzipping it, you should have a
`recitation02/` directory with the following contents:

    recitation02
    ├── .project
    ├── .settings
    │   ├── org.eclipse.core.resources.prefs
    │   └── org.sasylf.prefs
    ├── README.md
    └── slf
        └── edu
            └── cmu
                └── cs
                    └── plp
                        └── recitation2.slf

Their purposes are as follows:

- `README.md` is this file. :)
- `.project` and `.settings` are used by Eclipse. You should be able to ignore
  these.
- `slf/edu/cmu/cs/plp/recitation2.slf` is the file we'll be exploring in this
  recitation.

## Import into Eclipse

In Eclipse, click **File > Open Projects from File System...** and then use the
**Directory...** button to select the aforementioned `recitation02/` directory,
then click **Finish**. Now under **Project Explorer**, you should now see a
`recitation02` project: expand the arrows and open `recitation2.slf`.

## Exercise

In recitation we'll go over what's already present in `recitation2.slf`. Then
there should be a couple TODOs, which you can replace by filling in the
necessary code.

## Exploration

1. In `recitation2.slf`, we declare `x` as a terminal. This means that, unlike
   language you saw in class, this expression language can only involve
   literally the variable `x`, and no other variables. What is an approach we
   could use to allow multiple different variable names? Are there any downsides
   or potential pitfalls to that approach?
2. Come up with another theorem involving our little expression language, and
   state the theorem (using `proof by unproved` for now) in SASyLF. How would
   you go about proving your theorem? Do you feel like we're currently missing
   anything that you would need in order to prove it?

## Recitation Slides
Recitation slides can be found [here](https://docs.google.com/presentation/d/1XhMgocOhVJ9tyIoW0oIcaFRhvPFGj2TbDaEIz348dss/edit?usp=sharing).
