function [rewardsMean, rewardsSqSum, explicitBid] = initPriorBoundedISMIS( advertiser, topicMeans, difficultyProfile, candidates , budget, rewardsMean, rewardsSqSum, explicitBid)

deltas = topicMeans - difficultyProfile;

[B,I] = sort(deltas,'descend');
numCandidates = numel(candidates);


%The two reported topics and skills
topTopic = I(1);
topSkill = topicMeans(topTopic);


secondTopTopic = I(2);
secondTopSkill = topicMeans(secondTopTopic);


for k=1:numCandidates
   rewardsMean(candidates(k),topTopic,advertiser) = topSkill;
   explicitBid(candidates(k),topTopic,advertiser) = 1;
   
   rewardsMean(candidates(k),secondTopTopic,advertiser) = secondTopSkill;
   explicitBid(candidates(k),secondTopTopic,advertiser) = 1;
end

bound = B(2);

for topicIndex = 3:10
    topic = I(topicIndex);
        for k=1:numCandidates
           rewardsMean(candidates(k),topic,advertiser) = difficultyProfile(topic) + bound;
        end
    
end

end






