import warnings

def deprecated(func):
    """This is a decorator which can be used to mark functions
    as deprecated. It will result in a warning being emmitted
    when the function is used."""
    def newFunc(*args, **kwargs):
        warnings.warn("Call to deprecated function %s." % func.__name__,
                      category=DeprecationWarning)
        return func(*args, **kwargs)
    newFunc.__name__ = func.__name__
    newFunc.__doc__ = func.__doc__
    newFunc.__dict__.update(func.__dict__)
    return newFunc

def is_star(D, i, j, k, l, tolerance=0.00001):
    """
    Tests is i,j,k,l form a star with respect to the implicit tree D
    D -- distance matrix on leaves
    i,j,k,l -- indices of leaves in D
    """
    return pairs_with(D, i, j, k, l, tolerance=tolerance) and pairs_with(D, i, k, j, l, tolerance=tolerance) and pairs_with(D, i, l, j, k, tolerance=tolerance)
        
def pairs_with(D, i, j, k, l, tolerance=0.00001):
    """
    Tests is i and j pair with each other (and by symmetry if k and l) pair with
    each other with respect to the implicit tree D
    D -- distance matrix on leaves
    i,j,k,l -- indices of leaves in D
    """
    return abs(D.get(i,k) + D.get(j,l) - D.get(i,l) - D.get(j,k)) <= tolerance

def translate_mapping(mapping):
    """
    helper routine to translate a mapping from a forest object into a mapping
    where mapping[i] is the index of the ith leaf in the tree. Recall that the
    forest mapping is more or less the opposite of this, where fmapping[j] is
    None if the jth node in the tree is an internal node and is i if the jth
    node in the tree is the ith leaf
    """
    return [x[1] for x in sorted([x for x in zip(mapping, range(len(mapping))) if x[0] != None], key=lambda x: x[0])]
