class UnionFind(object):
    def __init__(self, obs):
        self.trees = []
        self.mapping = {}
        self.active = []
        for o in obs:
            self.add_object(o)


    def add_object(self, o):
        self.trees.append(UFTree(o, None))
        self.mapping[o] = len(self.trees)-1
        self.active.append(True)

    def find(self, o):
        if o not in self.mapping:
            return UFTree(-1, None)
        t = self.trees[self.mapping[o]]
        t2 = t
        while t.parent != None:
            t = t.parent
        while t2 != t:
            tmp = t2.parent
            t2.parent = t
            t2 = tmp
        return t
        
    def union(self, o1, o2):
        o1 = self.find(o1)
        o2 = self.find(o2)
        o1.setParent(o2)
        self.active[self.mapping[o1.data]] = False

    def get_active(self):
        return [self.trees[i].data for i in range(len(self.trees)) if self.active[i]]

class UFTree(object):
    def __init__(self, data, parent):
        self.data = data
        self.parent = parent
#         self.children = []
#         if parent != None:
#             parent.children.append(self)

    def setParent(self, other):
        self.parent = other
#         other.children.append(self)
