import getopt, sys, re
import numpy as np

rexp = re.compile("""destination: \d+\.\d+\.\d+\.\d+ hops: [0-9:\s\.]* 0\.0\.0\.0 [0-9:\s\.]*""")

def trace_to_distance_matrix(fName):
    f = "".join(open(fName).readlines())
    newf = rexp.sub("", f)
    nodes = []
    dests = 0
    for line in newf.split("\n"):
        parts = re.split('\s', line)
        if len(parts) > 1:
            if parts[0] == 'destination:':
                dests += 1
                continue
            if parts[1] not in nodes:
                nodes.append(parts[1])


    adjMat = np.zeros([len(nodes), len(nodes)])
    distMat = np.zeros([dests, dests])

    destCount = 0
    target = None
    curr = None
    length = 0
    path = []
    destMapping = []
    f = open(fName)
    for line in newf.split("\n"):
        parts = re.split('\s', line)
        if len(parts) > 1:
            if parts[0] == 'destination:':
                print line
                target = parts[1]
                continue
            length = length+float(parts[2])
            if parts[0] == '0:':
                curr = parts[1]
            else:
                next = parts[1]
                adjMat[nodes.index(curr), nodes.index(next)] = 1;
                adjMat[nodes.index(next), nodes.index(curr)] = 1;
                curr = next
            if parts[1] == 'target':
                curr = None
                distMat[0, destCount] = length
                destCount += 1
                destMapping.append(target)

    f1 = open("trace_adjMat.dat", "w")
    for i in xrange(len(nodes)):
        f1.write(" ".join([str(x) for x in adjMat[i]]) + "\n")
    f1.close()

if __name__=='__main__':
    optlist, args = getopt.getopt(sys.argv[1:], '')
    trace_to_distance_matrix(args[0])
