from util import *
import tree, generate, counting_matrix
import numpy as np

def test_is_star():
    T = tree.Tree(np.array([[0, 1, 1, 1, 1],
                            [1, 0, 0, 0, 0],
                            [1, 0, 0, 0, 0],
                            [1, 0, 0, 0, 0],
                            [1, 0, 0, 0, 0]]))
    D = T.paths[np.ix_(T.findleaves(), T.findleaves())]
    assert is_star(counting_matrix.Matrix(D), 0, 1, 2, 3)

def test_pairs_with():
    T = tree.Tree(generate.generate_balanced_binary(3*2))
    D = T.paths[np.ix_(T.findleaves(), T.findleaves())]
    assert pairs_with(counting_matrix.Matrix(D), 0, 1, 2, 3)
    assert not pairs_with(counting_matrix.Matrix(D), 0, 2, 1, 3)

def test_translate_mapping():
    mapping = [None, 0, 1, None, 3, None, 2]
    out = translate_mapping(mapping)
    assert out == [1, 2, 6, 4]

