from subtree import *
import generate, tree
import numpy as np
################################################################
## 
##    Test Suite
##
#################################################################

class TestSubtree():
    def setUp(self):
        self.tiny = Subtree(tree.Tree(generate.generate_rooted_balanced_binary(2)))
        self.large = Subtree(tree.Tree(generate.generate_rooted_balanced_binary(8)))
        self.unrooted = Subtree(tree.Tree(generate.generate_balanced_binary(12)))
    
    def test_deleteUnreachable(self):
        self.tiny.deleteUnreachable(1, 0)
        assert (self.tiny.adjMat.toarray() == np.array([[0, 1, 1], [1, 0, 0], [1, 0, 0]])).all()
        assert (self.tiny.existent == set([0, 1, 2]))
        self.tiny.deleteUnreachable(0, 1)
        assert (self.tiny.adjMat.toarray() == np.array([[0, 1, 0], [1, 0, 0], [0, 0, 0]])).all()
        assert (self.tiny.existent == set([0, 1]))
        assert self.tiny.connected()

        self.large.deleteUnreachable(0, 1)
        assert (self.large.existent == set([0, 1, 3, 4, 7, 8, 9, 10]))
        self.large.deleteUnreachable(7, 3)
        assert (self.large.existent == set([0, 1, 3, 4, 7, 8, 9, 10]))
        self.large.deleteUnreachable(3, 1)
        assert (self.large.existent == set([0, 1, 3, 4, 9, 10]))
        assert (self.large.connected)

    def test_deleteSubtrees(self):
        self.tiny.deleteSubtrees(0, [1, 2])
        assert (self.tiny.adjMat.toarray() == np.zeros((3,3))).all()
        self.large.deleteSubtrees(1, [0, 4])
        assert (self.large.existent == set([1, 3, 7, 8]))

    def test_connected(self):
        empty = Subtree(tree.Tree(np.array([0])))
        empty.connected()
