from hierarchical import *
import tree, generate
import numpy as np

def test_hierarchical():
    T = tree.Tree(generate.generate_rooted_balanced_binary_no_args())
    D = T.sharedPaths()
    D = D[np.ix_(T.findleaves(), T.findleaves())]
    (T, mapping, root) = hierarchical(D)
    assert (T.sharedPaths(root)[np.ix_(mapping, mapping)] == D).all()


def test_single_linkage():
    T = tree.Tree(generate.generate_balanced_binary_no_args())
    D = T.paths[np.ix_(T.findleaves(), T.findleaves())]
    D = -1 * D
    F = single_linkage(D, [0,1,2,3,4,5], k=3)
    assert len(F.active()) == 3
    for x in F.active():
        l = [i for i in x[1] if i != None]
        assert l == [0, 1] or l == [2, 3] or l == [4, 5]

