from graph import *
import numpy as np
import generate
from nose.tools import raises

################################################################
## 
##    Test Suite
##
#################################################################

class TestGraph():
    def setUp(self):
        self.emptygraph = Graph()
        self.tree = Graph(np.array([[0, 1, 0], [1, 0, 0], [0, 0, 0]]))
        self.cycle = Graph(np.array([[0, 1, 1], [1, 0, 1], [1, 1, 0]]))
        self.large = Graph(generate.generate_rooted_balanced_binary(8))

    def test_addEdge(self):
        self.tree.addEdge(0, 2, 0.5)
        self.tree.allpairsshortestpaths()
        assert (self.tree.paths == np.array([[0, 1, 0.5], [1, 0, 1.5], [0.5, 1.5, 0]])).all()

    def test_addEdges(self):
        self.tree.addEdges([(0, 2, 0.5), (1, 2, 0.5)])
        self.tree.allpairsshortestpaths()
        assert (self.tree.paths == np.array([[0, 1, 0.5], [1, 0, 0.5], [0.5, 0.5, 0]])).all()
        
    def test_addVertex(self):
        self.emptygraph.addVertex()
        assert (self.emptygraph.adjMat.toarray() == np.array([[0, 0], [0,0]])).all()
        self.emptygraph.addEdge(0, 1, 10)
        assert (self.emptygraph.adjMat.toarray() == np.array([[0, 10], [10, 0]])).all()

    def test_delEdge(self):
        assert (self.cycle.paths == np.array([[0, 1, 1], [1, 0, 1], [1, 1, 0]])).all()
        self.cycle.delEdge(1, 2)
        assert (self.cycle.adjMat.toarray() == np.array([[0, 1, 1], [1, 0, 0], [1, 0, 0]])).all()
        self.cycle.allpairsshortestpaths()
        assert (self.cycle.paths == np.array([[0, 1, 1], [1, 0, 2], [1, 2, 0]])).all()

    def test_findleaves(self):
        assert len(np.setxor1d(self.tree.findleaves(), [0, 1])) == 0
        self.tree.addEdge(0, 2, 0.5)
        assert len(np.setxor1d(self.tree.findleaves(), [1, 2])) == 0
        assert len(np.setxor1d(self.large.findleaves(), range(7, 15))) == 0

    def test_numVertices(self):
        assert self.large.numVertices() == 15

    def test_numEdges(self):
        assert self.large.numEdges() == 14

    def test_computeMaxDegree(self):
        assert self.large.degree == 3
        self.large.addEdge(1, 7, 10)
        self.large.computeMaxDegree()
        assert self.large.degree == 4

    def test_addZeroEdge(self):
        G = Graph(np.array([[0, 0], [0, 0]]))
        G.addEdge(0, 1, 0)
        G.allpairsshortestpaths()
        assert (G.paths == np.array([[0, 1*10**-20],
                                     [1*10**-20, 0]])).all()

    def test_edgeNodes(self):
        (M,G) = generate.generate_clique_fringe(4)
        assert (np.array(M.edgeNodes()) == np.array([0,1,2,3])).all()

    def test_sharedPathMatrix(self):
        (M,G) = generate.generate_clique_fringe(3)
        (P, leaves) = M.sharedPathMatrix(0)
        assert (P  == np.array([[ 0.,  0.,  0.,  0.,  0.,  0.],
                                [ 0.,  3.,  1.,  1.,  2.,  1.],
                                [ 0.,  1.,  3.,  1.,  1.,  2.],
                                [ 0.,  1.,  1.,  1.,  1.,  1.],
                                [ 0.,  2.,  1.,  1.,  2.,  1.],
                                [ 0.,  1.,  2.,  1.,  1.,  2.]])).all()
        assert (np.array(leaves) == np.array([1,2])).all()

        M = Graph(np.array([[0, 1, 0, 0], [1, 0, 1, 0], [0, 1, 0, 1], [0, 0, 1, 0]]))
        (P, leaves) = M.sharedPathMatrix(0)
        assert (np.array(leaves) == np.array([3])).all()
        assert (P == np.array([[0, 0, 0, 0], [0, 1, 1, 1], [0, 1, 2, 2], [0, 1, 2, 3]])).all()

        (P, leaves) = M.sharedPathMatrix(1)
        assert (np.array(leaves) == np.array([0, 3])).all()
        assert (P == np.array([[1, 0, 0, 0], [0, 0, 0, 0], [0, 0, 1, 1], [0, 0, 1, 2]])).all()


    @raises(Exception)
    def test_sharedPathMatrix2(self):
        M = Graph(np.array([[0, 1, 1, 0], [1, 0, 1, 0], [1, 1, 0, 0], [0, 0, 0, 0]]))
        M.sharedPathMatrix(0)
        assert False
