from forest import *
import generate, tree
import numpy as np

################################################################
## 
##    Test Suite
##
#################################################################
class TestForest():
    def test_constructor(self):
        F = Forest()
        assert len(F.forest) == 0
        assert len(F.mappings) == 0
        assert len(F.roots) == 0

    def test_addTree(self):
        F = Forest()
        T = tree.Tree(generate.generate_rooted_balanced_binary(2))
        idx = F.addTree(T, 0, [None, 0, 1])
        assert (F.forest[idx].adjMat.toarray() == np.array([[0, 1, 1], [1, 0, 0], [1, 0, 0]])).all()
        assert (F.mappings[idx] == [None, 0, 1])
        assert (F.roots[idx] == 0)

        T = tree.Tree(generate.generate_rooted_balanced_binary(4))
        idx = F.addTree(T, 0, [None, None, None, 0, 1, 2, 3])
        assert (F.roots[idx] == 0)

    def test_merge(self):
        ## test merging with both l1 and l2 nonzero
        F = Forest()
        T = tree.Tree(generate.generate_rooted_balanced_binary(2))
        idx = F.addTree(T, 0, [None, 0, 1])
        T = tree.Tree(generate.generate_rooted_balanced_binary(2))
        idx2 = F.addTree(T, 0, [None, 2, 3])

        idx = F.merge(idx, idx2, 1, 1)
        assert (F.forest[idx].paths == np.array([[0, 1, 1, 2, 3, 3, 1],
                                                 [1, 0, 2, 3, 4, 4, 2],
                                                 [1, 2, 0, 3, 4, 4, 2],
                                                 [2, 3, 3, 0, 1, 1, 1],
                                                 [3, 4, 4, 1, 0, 2, 2],
                                                 [3, 4, 4, 1, 2, 0, 2],
                                                 [1, 2, 2, 1, 2, 2, 0]])).all()
        assert (F.mappings[idx] == [None, 0, 1, None, 2, 3, None])

        F = Forest()
        T = tree.Tree(generate.generate_rooted_balanced_binary(2))
        idx = F.addTree(T, 0, [None, 0, 1])
        T = tree.Tree(generate.generate_rooted_balanced_binary(2))
        idx2 = F.addTree(T, 0, [None, 2, 3])
        idx = F.merge(idx, idx2, 1, 0)
        assert (F.forest[idx].paths == np.array([[0, 1, 1, 1, 2, 2],
                                                 [1, 0, 2, 2, 3, 3],
                                                 [1, 2, 0, 2, 3, 3],
                                                 [1, 2, 2, 0, 1, 1],
                                                 [2, 3, 3, 1, 0, 2],
                                                 [2, 3, 3, 1, 2, 0]])).all()
        
        F = Forest()
        T = tree.Tree(generate.generate_rooted_balanced_binary(2))
        idx = F.addTree(T, 0, [None, 0, 1])
        T = tree.Tree(generate.generate_rooted_balanced_binary(2))
        idx2 = F.addTree(T, 0, [None, 2, 3])
        idx = F.merge(idx, idx2, 0, 1)
        assert (F.forest[idx].paths == np.array([[0, 1, 1, 1, 2, 2],
                                                 [1, 0, 2, 2, 3, 3],
                                                 [1, 2, 0, 2, 3, 3],
                                                 [1, 2, 2, 0, 1, 1],
                                                 [2, 3, 3, 1, 0, 2],
                                                 [2, 3, 3, 1, 2, 0]])).all()

        F = Forest()
        T = tree.Tree(generate.generate_rooted_balanced_binary(2))
        idx = F.addTree(T, 0, [None, 0, 1])
        T = tree.Tree(generate.generate_rooted_balanced_binary(2))
        idx2 = F.addTree(T, 0, [None, 2, 3])
        idx = F.merge(idx, idx2, 0, 0)
        assert (F.forest[idx].paths == np.array([[0, 1, 1, 1e-20, 1+1e-20, 1+1e-20],
                                                 [1, 0, 2, 1+1e-20, 2+1e-20, 2+1e-20],
                                                 [1, 2, 0, 1+1e-20, 2+1e-20, 2+1e-20],
                                                 [1e-20, 1+1e-20, 1+1e-20, 0, 1, 1],
                                                 [1+1e-20, 2+1e-20, 2+1e-20, 1, 0, 2],
                                                 [1+1e-20, 2+1e-20, 2+1e-20, 1, 2, 0]])).all()
        
                                                 
                                                 
        
