from evaluate import *
import numpy as np
import counting_matrix

def test_eval_quartets():
    D = np.array([[0, 2, 4, 4],
                  [2, 0, 4, 4],
                  [4, 4, 0, 2],
                  [4, 4, 2, 0]])
    assert eval_quartets(counting_matrix.CountingMatrix(D), counting_matrix.CountingMatrix(D), tolerance = 0) == 1
    assert eval_quartets(counting_matrix.CountingMatrix(D), counting_matrix.CountingMatrix(D), numSamples = 10, tolerance = 0) == 1
    D = np.array([[0, 2, 2, 2],
                  [2, 0, 2, 2],
                  [2, 2, 0, 2],
                  [2, 2, 2, 0]])
    assert eval_quartets(counting_matrix.CountingMatrix(D), counting_matrix.CountingMatrix(D), tolerance = 0) == 1
    assert eval_quartets(counting_matrix.CountingMatrix(D), counting_matrix.CountingMatrix(D), numSamples = 10, tolerance = 0) == 1
    D = np.array([[0, 4, 2, 4],
                  [4, 0, 4, 2],
                  [2, 4, 0, 4],
                  [2, 4, 4, 0]])
    assert eval_quartets(counting_matrix.CountingMatrix(D), counting_matrix.CountingMatrix(D), tolerance = 0) == 1

def test_eval_relative_error():
    D = np.array([[0, 4, 2, 4],
                  [4, 0, 4, 2],
                  [2, 4, 0, 4],
                  [2, 4, 4, 0]])
    lst = eval_relative_error(D, D)
    assert (np.array(lst) == 0).all()

def test_eval_absolute_error():
    D = np.array([[0, 4, 2, 4],
                  [4, 0, 4, 2],
                  [2, 4, 0, 4],
                  [4, 2, 4, 0]])
    out = eval_absolute_error(D, D)
    assert (np.array(out) == 0).all()

