from dfs_ordering import *
from counting_matrix import *
import generate, tree
import numpy as np
import random

def test_dfs_ordering():
    Tin = tree.Tree(generate.generate_rooted_balanced_binary(4))
    leaves = Tin.findleaves()
    D = Tin.sharedPaths()[np.ix_(leaves, leaves)]
    (T, mapping, root) = dfs_ordering(CountingMatrix(D), 0.5)
    assert (T.sharedPaths(root)[np.ix_(mapping, mapping)] == D).all()

    Tin = tree.Tree(generate.generate_rooted_balanced_binary(8))
    leaves = Tin.findleaves()
    D = Tin.sharedPaths()[np.ix_(leaves, leaves)]
    (T, mapping, root) = dfs_ordering(CountingMatrix(D), 0.5)
    assert (T.sharedPaths(root)[np.ix_(mapping, mapping)] == D).all()

    Tin = tree.Tree(generate.generate(20))
    leaves = Tin.findleaves()
    root = random.choice(list(set(range(Tin.adjMat.shape[0])).difference(set(leaves))))
    D = Tin.sharedPaths(root)[np.ix_(leaves, leaves)]
    C = CountingMatrix(D)
    (T, mapping, root) = dfs_ordering(C, 0.5)
    assert (T.sharedPaths(root)[np.ix_(mapping, mapping)] == D).all()
