import random
import numpy as np
import numpy.random
import copy
from util import *

class TreeNode(object):
    def __init__(self, i = 0):
        self.index = i
        self.children = []
        self.degree = 1

@deprecated
def simTree(leaves, aveBranching=2):
    if leaves == 0:
        return None
    root = TreeNode()
    queue = [root]
    curLeaves = 1
    while curLeaves < leaves:
        parent = queue.pop()
        newLeaves = random.randint(1, aveBranching)+1
        # make sure we don't make too many leaves
        if newLeaves+curLeaves > leaves+1:
            newLeaves = leaves - curLeaves
        newLeaves = [TreeNode() for i in range(newLeaves)]
        parent.children = newLeaves
        [queue.append(newLeaf) for newLeaf in newLeaves]
        curLeaves += len(newLeaves)-1
    return root


@deprecated
def printTree(tree):
    if tree != None:
        return "(" + " ".join(map(printTree, tree.children)) + ")"


@deprecated
def debugTree(tree):
    print "(%d ( %s ))" % (tree.index," ".join([str(x.index) for x in tree.children]))


def pruferSequence(n):
    seq = []
    for i in range(n-2):
        seq.append(random.randint(0, n-1))
    return seq

def pruferTree(seq):
    n = len(seq)
    tree = np.zeros((n+2, n+2))
    nodes = [TreeNode(i) for i in range(0,n+2)]
    for s in seq:
        nodes[s].degree += 1
    
    for i in seq:
        for j in range(len(nodes)):
            if nodes[j].degree == 1:
                tree[i,j] = 1
                tree[j,i] = 1
                nodes[j].degree -= 1
                nodes[i].degree -= 1
                break
    u = 0
    v = 0
    for node in nodes:
        if node.degree == 1 and u == 0:
            u = node.index
        elif node.degree == 1:
            v = node.index
    tree[u,v] = 1
    tree[v,u] = 1
    nodes[u].degree -= 1
    nodes[v].degree -= 1
    return tree


def simulateTree(n):
    def pruferSequence(n):
        seq = []
        for i in range(n-2):
            seq.append(random.randint(0, n-1))
        return seq

    def pruferTree(seq):
        n = len(seq)
        tree = np.zeros((n+2, n+2))
        nodes = [TreeNode(i) for i in range(0,n+2)]
        for s in seq:
            nodes[s].degree += 1
    
        for i in seq:
            for j in range(len(nodes)):
                if nodes[j].degree == 1:
                    tree[i,j] = 1
                    tree[j,i] = 1
                    nodes[j].degree -= 1
                    nodes[i].degree -= 1
                    break
        (u,v) = [x[0] for x in filter(lambda x: x[1] == 1, [(x.index, x.degree) for x in nodes])]

        for node in nodes:
            if node.degree == 1 and u == 0:
                u = node.index
            elif node.degree == 1:
                v = node.index
        tree[u,v] = 1
        tree[v,u] = 1
        nodes[u].degree -= 1
        nodes[v].degree -= 1
        return tree
    
    return pruferTree(pruferSequence(n))

def simulateTree2(n, var):
    tree = np.zeros((n,n))
    dist = abs(numpy.random.normal(0, var, (n-1, 1, 1)))
    for i in range(1, n):
        index = random.randint(0,i-1)
        tree[index,i] = dist[i-1]
        tree[i,index] = dist[i-1]
    return tree

def allPairsShortestPaths(tree):
    curr = copy.deepcopy(tree)
    for k in range(0, tree.shape[0]):
        for i in range(0, tree.shape[0]):
            if i != k:
                for j in range(0, tree.shape[0]):
                    if j != i and j != k:
                        if curr[i,k] == 0 or curr[k,j] == 0:
                            pass
                        elif curr[i,k] != 0 and curr[k,j] != 0:
                            if curr[i,j] != 0:
                                curr[i,j] = min(curr[i,j], curr[i,k] + curr[k,j])
                            else:
                                curr[i,j] = curr[i,k] + curr[k,j]
    return curr

if __name__=="__main__":
    tree = simulateTree2(5,10)
    print tree
    print allPairsShortestPaths(tree)
