import getopt, sys
import numpy as np
import random
import heapq
from itertools import izip
import copy
import re
from dijkstra import Dijkstra

def inet_to_distance_matrix(f):
    f = open(f)
    n = int(f.readline().split(" ")[0])
    print "Creating network with %d nodes" % (n)
    i = 0
    while i < n:
        f.readline()
        i += 1
    adjMat = np.zeros([n, n])
    adjMat2 = {}
    for i in xrange(n):
        adjMat2[i] = {}

    for line in f:
        parts = re.split('\s', line)
#         print "%d %d %d" % (int(parts[0]), int(parts[1]), int(parts[2]))
        adjMat[int(parts[0]), int(parts[1])] = int(parts[2])
        adjMat[int(parts[1]), int(parts[0])] = int(parts[2])
        adjMat2[int(parts[0])][int(parts[1])] = int(parts[2])
        adjMat2[int(parts[1])][int(parts[0])] = int(parts[2])

    leaves = findLeaves(adjMat2)
    root = random.choice(list(set(range(n)).difference(leaves)))

    dists, paths = Dijkstra(adjMat2, root)


    D = np.zeros([len(leaves), len(leaves)])
    for i in xrange(len(leaves)):
        for j in xrange(len(leaves)):
            if j != i:
                # find the internal node where the two branch
                ancestorInd = 0
                iPath = paths[leaves[i]]
                jPath = paths[leaves[j]]
#                 print iPath
#                 print jPath
                while iPath[ancestorInd] == jPath[ancestorInd]:
                    ancestorInd += 1
                ancestorInd -= 1
#                 print "%d %d" % (iPath[ancestorInd], jPath[ancestorInd])
                D[i,j] = dists[leaves[i]] + dists[leaves[j]] - 2*dists[iPath[ancestorInd]]
                D[j,i] = D[i,j]
                if D[i,j] < 0:
                    raise ValueError, "Negative Distance"


    f1 = open("adjMat.dat", "w")
    for i in xrange(n):
        f1.write(" ".join([str(x) for x in adjMat[i]]) + "\n")
    f1.close()
    f2 = open("distMat.dat", "w")
    for i in xrange(len(leaves)):
        f2.write(" ".join([str(x) for x in D[i]]) + "\n")
    f2.close()
    f3 = open("mapping.dat", "w")
    for i in xrange(len(leaves)):
        f3.write(str(i) + " " + str(leaves[i]) + "\n")
    f3.close()
            

def findLeaves(M):
    leaves = [i[0] for i in M.items() if len(i[1]) == 1]
    return leaves

if __name__=='__main__':
    optlist, args = getopt.getopt(sys.argv[1:], '')
    inet_to_distance_matrix(args[0])
