import tree
import numpy as np

"""
DFS Ordering algorithm from Eriksson et al.  Note that this algorithm operates
on the shared-paths matrix rather than the distance matrix.
"""

def bisect(D, gap):
    """
    Helper routine. 
    """
    n = D.shape[0]
    Y = [D.get(0, x) for x in range(n)]

    S = sorted(zip(Y, range(len(Y))), key=lambda x: x[0], reverse=True)
    S = [x[1] for x in S]
    Szipped = zip(S[0:(len(S)-1)], S[1:len(S)])
    Idelta = [x[0] for x in Szipped if Y[x[0]] - Y[x[1]] > gap]
    ## find the i in Idelta that best bisects the list S
    best = int(np.floor(n/2))
    bestScore = n/2
    for i in Idelta:
        idx = S.index(i)
        if abs(idx - n/2) <= n/2:
            best = idx
            bestScore = abs(idx - n/2)
    X1 = S[0:best+1]
    X2 = S[best+1:len(S)]
    I1 = X1
    if len(X1) > 2:
        I1 = bisect(D.submatrix(X1), gap)
        X1 = [X1[i] for i in I1]
    if len(X2) > 2:
        I2 = bisect(D.submatrix(X2), gap)
        X2 = [X2[i] for i in I2]
    X1.extend(X2)
    return X1

def dfs_ordering(D, gap, verbose=False):
    """
    Main DFS ordering algorithm.
    """
    n = D.shape[0]
    Ord = bisect(D, gap)
    if verbose:
        print Ord
    p0len = D.get(Ord[0], Ord[0]) - D.get(Ord[0], Ord[1])
    p0len = p0len if p0len > 0 else 0.01
    p1len = D.get(Ord[1], Ord[1]) - D.get(Ord[0], Ord[1])
    p1len = p1len if p1len > 0 else 0.01
    T = tree.Tree(np.array([[0, p0len, p1len],
                            [p0len, 0, 0], 
                            [p1len, 0, 0]]))
    routerDists = {0 : D.get(Ord[0], Ord[1])}
    mapping = np.zeros(n)
    mapping[Ord[0]] = 1
    mapping[Ord[1]] = 2
    root = 0
    for i in xrange(2, n):
        xi = Ord[i]
        if verbose:
            print "xi: %d Ord[i-1]: %d Ord[i-2]: %d Ord[i]: %d" % (xi, Ord[i-1], Ord[i-2], Ord[i])
            print "%f %f" % (D.get(Ord[i-1], Ord[i-2]), D.get(Ord[i], Ord[i-1]))
        if abs(D.get(Ord[i-1], Ord[i-2]) - D.get(Ord[i], Ord[i-1])) < gap:
            parent = T.neighbors(mapping[Ord[i-1]])[0]
            plen = D.get(xi, xi) - D.get(xi, Ord[i-1])
            plen = plen if plen > 0 else 0.01
            if verbose:
                print "#1 Adding vertex below: %d len %f" % (parent, plen)
            idx = T.addVertex({parent : plen})
            mapping[xi] = idx
        elif D.get(Ord[i-1], Ord[i-2]) + gap < D.get(Ord[i], Ord[i-1]):
            parentlen = D.get(Ord[i-1], Ord[i]) - D.get(Ord[i-1], Ord[i-2])
            parentlen = parentlen if parentlen > 0 else 0.01
            p1len = D.get(Ord[i-1], Ord[i-1]) - D.get(Ord[i-1], Ord[i])
            p1len = p1len if p1len > 0 else 0.01
            p0len = D.get(Ord[i], Ord[i]) - D.get(Ord[i-1], Ord[i])
            p0len = p0len if p0len > 0 else 0.01
            parent = T.neighbors(mapping[Ord[i-1]])[0]
            newNode = T.addVertexBetween(parent, mapping[Ord[i-1]], parentlen)
            routerDists[newNode] = routerDists[parent] + parentlen
            idx = T.addVertex({newNode : p0len})
            if verbose:
                print "Adding vertex between %d and  %d with distances: %d %d" % (parent, mapping[Ord[i-1]], parentlen, p1len)
                print "#2 Adding vertex below: %d len %d" % (newNode, p0len)
            mapping[xi] = idx
        else:
            ## find ancestor of Ord[i-1] with path[anc] >= D.get(Ord[i], Ord[i-1])
            curr = T.neighbors(mapping[Ord[i-1]])[0]
            ref = D.get(Ord[i-1], Ord[i])
            if routerDists[curr] <= ref:
                D.data[Ord[i-1], Ord[i]] = routerDists[curr]
                ref = D.data[Ord[i-1], Ord[i]]
            while routerDists[curr] >= ref:
                update = [x for x in T.neighbors(curr) if x in routerDists.keys() and routerDists[x] < routerDists[curr]]
                if len(update) == 0 or routerDists[update[0]] < ref:
                    break
                else:
                    curr = update[0]
            assert routerDists[curr] >= ref
            if abs(routerDists[curr] - ref) < gap:
                p0len = D.get(xi,xi) - routerDists[curr]
                p0len = p0len if p0len > 0 else 0.01                
                idx = T.addVertex({curr : p0len})
                if verbose:
                    print "#3 Adding vertex below: %d len %d" % (curr, D.get(xi, xi) - routerDists[curr])
                mapping[xi] = idx
            elif routerDists[curr] >= ref + gap:
                parentcands = [x for x in T.neighbors(curr) if x in routerDists.keys() and routerDists[x] < routerDists[curr]]
                if len(parentcands) == 1:
                    parent = parentcands[0]
                    pnewlen = ref - routerDists[parent]
                    pnewlen = pnewlen if pnewlen > 0 else 0.01
                    pother = routerDists[curr] - ref
                    newNode = T.addVertexBetween(parent, curr, pnewlen)
                    routerDists[newNode] = ref
                    p0len = D.get(xi,xi) - ref
                    p0len = p0len if p0len > 0 else 0.01
                    idx = T.addVertex({newNode : p0len})
                    if verbose:
                        print "Adding vertex between %d and %d with distances: %d %d" % (parent, curr, pnewlen, pother)
                        print "#4 Adding vertex below: %d len %d" % (newNode, D.get(xi,xi) - ref)
                    mapping[xi] = idx
                else:
                    ## need to add a new parent
                    ## this is where we change the root
                    p0len = routerDists[curr] - ref
                    p0len = p0len if p0len > 0 else 0.01
                    parent = T.addVertex({curr : p0len})
                    root = parent
                    routerDists[parent] = ref
                    p0len = D.get(xi,xi) - ref
                    p0len = p0len if p0len > 0 else 0.01
                    idx = T.addVertex({parent : p0len})
                    if verbose:
                        print "Adding new root above  %d with distances: %d" % (curr, routerDists[curr] - ref)
                        print "#5 Adding vertex below: %d len %d" % (parent, D.get(xi,xi) - ref)
                    mapping[xi] = idx
    return (T, [int(x) for x in mapping], root)
