import numpy as np
import scipy.sparse
import apgl.graph
import subprocess
import re, os, sys
from util import *

import counting_matrix

"""
Library for loading various data sets. 
You will need to specify these files. 
"""

def load_king():
    f = np.loadtxt('../../matlab/data/king_matrix')
    return f
    
@deprecated
def load_iplane(n = 100):
    f = open("data/ip_to_pop_mapping.txt", "r")
    ## we're going to use only the first 1000 ip addresses
    i = 0
    ip_pop = {}
    pop_ip = {}
    print "reading ip_to_pop_mapping"
    for line in f.readlines():
        if i == n:
            break
        i += 1
        (ip, pop) = line.split(" ")
        pop = int(pop)
        ip_pop[ip] = pop
        if pop in pop_ip.keys():
            pop_ip[pop].append(ip)
        else:
            pop_ip[pop] = [ip]
        
    clusters = set(pop_ip.keys())
    mapping = ip_pop.keys()
    f = open("data/inter_pop_links.txt")
    G = scipy.sparse.dok_matrix((n,n))
    print "reading inter_pop_links"
    for line in f.readlines():
        (c1, as1, c2, as2, weight) = line.split(" ")
        c1 = int(c1)
        c2 = int(c2)
        if c1 in clusters and c2 in clusters:
            for x in pop_ip[c1]:
                for y in pop_ip[c2]:
                    G[mapping.index(x), mapping.index(y)] = float(weight)
                    G[mapping.index(y), mapping.index(x)] = float(weight)
    return (G, mapping)

@deprecated
def load_iplane_pops():
    f = open("data/inter_pop_links.txt")
    clusters = set()
    print "first pass"
    for line in f.readlines():
        (c1, as1, c2, as2, weight) = line.split(" ")
        c1 = int(c1)
        c2 = int(c2)
        clusters.add(c1)
        clusters.add(c2)

    n = len(clusters)
    clist = list(clusters)
    mapping = {}
    for i in range(len(clist)):
        mapping[clist[i]] = i

    f = open("data/inter_pop_links.txt")
    vlist = apgl.graph.VertexList(n)
    G = apgl.graph.SparseGraph(vlist)
    print "second pass: n = %d" % (n)
    for line in f.readlines():
        (c1, as1, c2, as2, weight) = line.split(" ")
        c1 = mapping[int(c1)]
        c2 = mapping[int(c2)]
        G.addEdge(c1, c2, edge=weight)
    return (G, mapping)


def convert_raw_traces():
    f = open("data/trace_names")
    for line in f.readlines():
        l = line.strip("\n")
        f2 = open("data/parsed/"+l, "w")
        print "data/traces/"+l
        subprocess.Popen(["./readoutfile", "./data/traces/"+l], stdout=f2)
    
def ping_pl_nodes():
    f = open("data/trace_names")
    for line in f.readlines():
        l = line.strip("\n")
        l = l[10:]
        f2 = open("data/pings/"+l, "w")
        print l
        subprocess.Popen(["ping", "-c", "1", l], stdout=f2)
        
def get_host_ips():
    reg = re.compile("\((.*)\)")
    f = open("data/trace_names")
    for line in f.readlines():
        l = line.strip("\n")
        l = l[10:]
        print l
        f2 = open("data/pings/"+l, "r")
        for line in f2.readlines():
            x = reg.search(line)
            if x != None:
                ip = x.groups(1)
                print ip
                f3 = open("data/ips/"+l, "w")
                f3.write(ip[0])

def iplane_dist_mat():
    f = open("data/trace_names")
    name_ip = {}
    ip_node = {}
    next = 0
    for line in f.readlines():
        l = line.strip("\n")
        l = l[10:]
        if os.path.exists("data/ips/"+l):
            f2 = open("data/ips/"+l, "r")
            ip = f2.readlines()[0]
            name_ip[l] = ip
            ip_node[ip] = next
            next += 1
            
    n = len(ip_node.keys())
    G = -1*np.ones((n,n))
    f = open("data/trace_names")
    reg = re.compile("destination: ([0-9\.]*) hops: ([0-9]*)")
    for line in f.readlines():
        l = line.strip("\n")
        l = l[10:]
        if os.path.exists("data/ips/"+l):
            f2 = open("data/parsed/"+line.strip("\n"), "r")
            for line in f2.readlines():
                x = reg.search(line)
                if x != None and x.groups()[0] in ip_node.keys():
#                     print ip_node[name_ip[l]]
#                     print ip_node[x.groups(1)[0]]
#                     print x.groups()[1]
                    G[ip_node[name_ip[l]], ip_node[x.groups(1)[0]]] = x.groups()[1]
                    G[ip_node[x.groups(1)[0]], ip_node[name_ip[l]]] = x.groups()[1]
    return G


def load_orbis_topo(fname):
    f = open(fname).readlines()
    f = [[int(i) for i in x.split(" ")] for x in f]
    maxvert = np.max([np.max(i) for i in f])
    print maxvert
    M = scipy.sparse.dok_matrix((maxvert+1, maxvert+1))
    for (x,y) in f:
        M[x,y] = 1
        M[y,x] = 1
    return M

node_mapping = [
    "osiris.planetlab.cs.umd.edu",
    "pl1.cs.yale.edu",
    "plab1.tidprojects.com",
    "plab4.eece.ksu.edu",
    "planetlab-1.cs.colostate.edu",
    "planetlab-5.eecs.cwru.edu",
    "planetlab02.just.edu.jo",
    "planetlab03.mpi-sws.mpg.de",
    "planetlab05.cs.washington.edu",
    "planetlab1.c3sl.ufpr.br",
    "planetlab1.cs.pitt.edu",
    "planetlab1.eecs.wsu.edu",
#     "planetlab1.iis.sinica.edu.tw",
    "planetlab1.pop-rs.rnp.br",
    "planetlab1.sfc.wide.ad.jp",
    "planetlab1.uta.edu",
    "planetlab2.cs.umass.edu",
    "planetlab2.hust.edu.cn",
    "planetlab3.inf.ethz.ch",
    "planetlab4.cs.uiuc.edu",
    "planetlab4.cs.uoregon.edu",
    "planetlab5.csee.usf.edu",
    "planetlab5.millennium.berkeley.edu",
    "planetlab7.cs.duke.edu",
    "planetlab8.millennium.berkeley.edu",
    "pln.zju.edu.cn",
    "pluto.cs.brown.edu",
    "planetlab-01.bu.edu",
    "planet1.cs.rochester.edu",
    "planetlab3.comp.nus.edu.sg"
    ]


def load_pl_spms(folder, folder2):
    SPMs = []
    mappings = []
    for f in os.listdir(folder):
        d = {}
        M = np.zeros((len(node_mapping), len(node_mapping)))
        for f2 in os.listdir(folder+"/"+f):
            s = open(folder+"/"+f+"/"+f2).readlines()
            name1 = ""
            name2 = ""
            use_next = False
            for line in s:
                if use_next:
                    if name1 not in node_mapping or name2 not in node_mapping:
                        use_next = False
                        continue
                    if line[0:3] == "all":
                        M[node_mapping.index(name1), node_mapping.index(name2)] = 0
                    else:
                        M[node_mapping.index(name1), node_mapping.index(name2)] = float(line)
                        if M[node_mapping.index(name1), node_mapping.index(name2)] < 0:
                            M[node_mapping.index(name1), node_mapping.index(name2)] = 0
                    name2 = ""
                    name1 = ""
                    use_next = False
                    continue
                if line[0:5] == "first":
                    name1 = line[line.index(":")+2:len(line)-1]
                if line[0:6] == "second":
                    name2 = line[line.index(":")+2:len(line)-1]
                if line[0:3] == "--A":
                    use_next = True

        for f2 in os.listdir(folder2+"/"+f):
            s = open(folder2+"/"+f+"/"+f2).readlines()
            name1 = ""
            name2 = ""
            use_next = False
            for line in s:
                if use_next:
                    if name1 not in node_mapping or name2 not in node_mapping:
                        use_next = False
                        continue
                    if line[0:3] == "all":
                        M[node_mapping.index(name1), node_mapping.index(name2)] = 0
                    else:
                        M[node_mapping.index(name1), node_mapping.index(name2)] = float(line)
                        if M[node_mapping.index(name1), node_mapping.index(name2)] < 0:
                            M[node_mapping.index(name1), node_mapping.index(name2)] = 0
                    name2 = ""
                    name1 = ""
                    use_next = False
                    continue
                if line[0:5] == "first":
                    name1 = line[line.index(":")+2:len(line)-1]
                if line[0:6] == "second":
                    name2 = line[line.index(":")+2:len(line)-1]
                if line[0:3] == "--A":
                    use_next = True

        to_keep = range(len(node_mapping))
        to_keep.remove(node_mapping.index(f))
        M[np.ix_(to_keep, to_keep)]
        to_keep = [node_mapping.index(f) if j == 0 else to_keep[j-1] for j in range(len(node_mapping))]
        mappings.append(to_keep)
        SPMs.append(counting_matrix.CountingMatrix(M))
    return (SPMs, mappings)
