function [Pi, Xhat] = svd_missing(M, r, m),
%% svd from randomly sampled entries. 
%% randomly sample the matrix, zero-fill and renormalize, then take
%% the top singular values as the principle subspace. 
  d = size(M, 1);
  n = size(M, 2);

  Xhat = zeros(d,n);

  for t=1:n,
      obs = unique(randi(d, [m,1]));
      yt = zeros(d,1);
      yt(obs,1) = M(obs, t);
      
      Xhat(:,t) = d/m*yt;
  end;
  
  [u,s,v] = svds(Xhat, r);
  Pi = u*u';
  Xhat = u*s*v';