%% Plot effect of increasing matrix rank on error
d = 50;
ns = [5000, 10000, 20000];
rs = 2:2:40;
k1 = 1;
k2 = 0;
m = 20;

es = zeros(size(ns,2), size(rs,2));
vs = zeros(size(ns,2), size(rs,2));
for i=1:size(ns,2),
    [e,v] = r_experiment(d, ns(i), rs, k1, k2, m);
    es(i,:) = e;
    vs(i,:) = v;
end;

f = figure();
errorbar(rs, es(1,:), vs(1,:), 'blue');
hold on;
l1 = plot(rs(1:2:end), es(1,1:2:end), 'bo', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'b');
errorbar(rs, es(2,:), vs(2,:), 'red');
l2 = plot(rs(1:2:end), es(2,1:2:end), 'rs', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'r');
errorbar(rs, es(3,:), vs(3,:), 'green');
l3 = plot(rs(1:2:end), es(3,1:2:end), 'gd', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'g');

h = xlabel('Target Rank (k)');
set(h, 'FontSize', 20);
h = ylabel('Error');
set(h, 'FontSize', 20);
set(gca, 'Fontsize', 20);
xlim([rs(1), rs(end)]);

legend([l1 l2 l3], sprintf('n=%d', ns(1)), sprintf('n=%d', ns(2)), sprintf('n=%d', ns(3)), 4);
saveas(f, './figs/r_fig.fig', 'fig');
saveas(f, './figs/r_fig.eps', 'epsc');