function [errs, vs] = r_experiment(d, N, rs, k1, k2, m, varargin),
%% Record error as a function of problem rank r. 
%% Generates a dxN matrix (either low_rank or aligned) of
%% "approximate" rank r and runs the compressive algorithm.

%% Parameters:
%% d,N -- problem dimension 
%% rs -- vector of ranks (or approximate rank)
%% k1 -- range parameter on the singular values in the directions
%% of interest.
%% k2 -- gap parameter between upper and lower ranks
%% m -- number of measurements to make per column
iters = 20;

errs = [];
vs = [];
for i=1:size(rs,2),
    suberrs = [];
    for j=1:iters;
        if k2 == 0,
            M = low_rank_matrix(d,N,rs(i),k1);
        else,
            M = aligned_matrix(d,N,rs(i),k2);
        end;

        [u,s,v] = eigs(M*M',rs(i));
        
        Pi = compressed_sl(M, rs(i), m);
        suberrs(j) = norm(Pi - u*u', 2);
    end;
    errs(i) = mean(suberrs);
    vs(i) = var(suberrs);
    fprintf('r = %d, err = %0.3f\n', rs(i), errs(i));
end;