function [Pi, Chat] = missing_sl(M, r, m),
%% Subspace learning algorithm from subsampling.
  d = size(M,1);
  N = size(M,2);
  Chat = zeros(d,d);
  for t=1:N,
      u_obs = unique(randi(d, [m,1]));
      v_obs = unique(randi(d, [int32(m/2),1]));

      uvec = zeros(d,1);
      vvec = zeros(d,1);
      
      uvec(u_obs,1) = M(u_obs,t);
      vvec(v_obs,1) = M(v_obs,t);
      Chat = Chat + uvec*uvec';
  end;
  [u,s,v] = eigs(Chat, r);
  Pi = u*u';
