%% Plot effect of increasing number of measurements per column on error
d = 50;
ns = [5000, 10000, 20000];
r = 5;
k1 = 1;
k2 = 0;
ms = 2:2:30;

es = zeros(size(ns,2), size(ms,2));
vs = zeros(size(ns,2), size(ms,2));
for i=1:size(ns,2),
    [e,v] = m_experiment(d, ns(i), r, k1, k2, ms);
    es(i,:) = e;
    vs(i,:) = v;
end;

f = figure();
errorbar(ms, es(1,:), vs(1,:), 'blue');
hold on;
l1 = plot(ms(1:2:end), es(1,1:2:end), 'bo', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'b');
errorbar(ms, es(2,:), vs(2,:), 'red');
l2 = plot(ms(1:2:end), es(2,1:2:end), 'rs', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'r');
errorbar(ms, es(3,:), vs(3,:), 'green');
l3 = plot(ms(1:2:end), es(3,1:2:end), 'gd', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'g');

h = xlabel('Measurements/Column (m)');
set(h, 'FontSize', 20);
h = ylabel('Error');
set(h, 'FontSize', 20);
set(gca, 'Fontsize', 20);
xlim([ms(1), ms(end)]);

legend([l1 l2 l3], sprintf('n=%d', ns(1)), sprintf('n=%d', ns(2)), sprintf('n=%d', ns(3)), 1);
saveas(f, './figs/m_fig.fig', 'fig');
saveas(f, './figs/m_fig.eps', 'epsc');