function [errs, vs] = m_experiment(d, N, r, k1, k2, ms, varargin),
%% Record error as a function of # of measurements m. 
%% Generates a dxN matrix (either low_rank or aligned) of
%% "approximate" rank r and runs the compressive algorithm.

%% Parameters:
%% d,N -- problem dimension
%% r -- rank (or approximate rank)
%% k1 -- range parameter on the singular values in the directions
%% of interest.
%% k2 -- gap parameter between upper and lower ranks
%% ms -- vector number of measurements to make per column
iters = 20;

errs = [];
vs = [];
for i=1:size(ms,2),
    suberrs = [];
    for j=1:iters;
        if k2 == 0,
            M = low_rank_matrix(d,N,r,k1);
        else,
            M = sep_matrix_additive(d,N,r,k1,k2);
        end;

        [u,s,v] = eigs(M*M',r);
        
        Pi = compressed_sl(M, r, ms(i));
        suberrs(j) = norm(Pi - u*u', 2);
    end;
    errs(i) = mean(suberrs);
    vs(i) = var(suberrs);
    fprintf('m = %d, err = %0.3f\n', ms(i), errs(i));
end;



