function [M] = low_rank_matrix(d,N,r,k1),
%% Generate an exactly low rank dxN matrix with rank r.
%% make the range between the top r singular values equal to k1. 
  M = normrnd(0,1,d,N);
  [u,s,v] = svd(M, 'econ');
  s = diag(s);
  if r > 1,
      vec = [2:-1/(r-1):1];
      s(1:r) = s(r)*k1*vec;
      
      s(r+1:end) = 0;
      
      M = u*diag(s)*v';
  else,
      s(2:end) = 0;
      M = u*diag(s)*v';
  end;
  
  %% Rescale all of the columns so they are norm one. 
  M = normc(M);