%% Plot how gap between upper and lower singular values influences
%% error. 
d = 10;
ns = [5000, 10000, 20000];
r = 2;
k1 = 1;
k2s = 0.05:0.05:0.95;
m = 5;

es = zeros(size(ns,2), size(k2s,2));
vs = zeros(size(ns,2), size(k2s,2));
for i=1:size(ns,2),
    [e,v] = gap_experiment(d, ns(i), r, k1, k2s, m);
    es(i,:) = e;
    vs(i,:) = v;
end;

f = figure();
errorbar(k2s, es(1,:), vs(1,:), 'blue');
hold on;
l1 = plot(k2s(1:2:end), es(1,1:2:end), 'bo', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'b');
errorbar(k2s, es(2,:), vs(2,:), 'red');
l2 = plot(k2s(1:2:end), es(2,1:2:end), 'rs', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'r');
errorbar(k2s, es(3,:), vs(3,:), 'green');
l3 = plot(k2s(1:2:end), es(3,1:2:end), 'gd', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'g');

h = xlabel('Eigengap');
set(h, 'FontSize', 20);
h = ylabel('Error');
set(h, 'FontSize', 20);
set(gca, 'Fontsize', 20);
xlim([k2s(1), k2s(end)]);

legend([l1 l2 l3], sprintf('n=%d', ns(1)), sprintf('n=%d', ns(2)), sprintf('n=%d', ns(3)), 1);
saveas(f, './figs/gap_fig.fig', 'fig');
saveas(f, './figs/gap_fig.eps', 'epsc');