function [errs,vs] = gap_experiment(d,N,r, k1, k2s, m, varargin)
%% record how the gap between upper and lower singular values plays
%% a role in parameter recovery errors. 
iters = 20;

errs = [];
vs = [];
for i=1:size(k2s,2),
    suberrs = [];
    for j=1:iters;
        if k2s(i) == 0,
            M = low_rank_matrix(d,N,r,k1);
        else,
            M = aligned_matrix(d,N,r,k2s(i));
        end;

        [u,s,v] = eigs(M*M',r);
        
        Pi = compressed_sl(M, r, m);
        suberrs(j) = norm(Pi - u*u', 2);
    end;
    errs(i) = mean(suberrs);
    vs(i) = var(suberrs);
    fprintf('ks = %d, err = %0.3f\n', k2s(i), errs(i));
end;